/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.filter.FilterServiceEntry;
import com.espertech.esper.filterspec.FilterValueSet;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.PatternConsumptionUtil;
import com.espertech.esper.pattern.PatternContext;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalFilterStateNode
extends EvalStateNode
implements FilterHandleCallback {
    protected final EvalFilterNode evalFilterNode;
    protected boolean isStarted;
    protected EPStatementHandleCallback handle;
    protected FilterServiceEntry filterServiceEntry;
    protected MatchedEventMap beginState;
    private static final Logger log = LoggerFactory.getLogger(EvalFilterStateNode.class);

    public EvalFilterStateNode(Evaluator parentNode, EvalFilterNode evalFilterNode) {
        super(parentNode);
        this.evalFilterNode = evalFilterNode;
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFilterNode;
    }

    @Override
    public int getStatementId() {
        return this.evalFilterNode.getContext().getPatternContext().getStatementId();
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        this.beginState = beginState;
        if (this.isStarted) {
            throw new IllegalStateException("Filter state node already active");
        }
        this.isStarted = true;
        this.startFiltering();
    }

    @Override
    public final void quit() {
        this.isStarted = false;
        this.stopFiltering();
    }

    private void evaluateTrue(MatchedEventMap theEvent, boolean isQuitted, EventBean optionalTriggeringEvent) {
        this.getParentEvaluator().evaluateTrue(theEvent, this, isQuitted, optionalTriggeringEvent);
    }

    public EvalFilterNode getEvalFilterNode() {
        return this.evalFilterNode;
    }

    @Override
    public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
        if (!this.isStarted) {
            return;
        }
        MatchedEventMap passUp = this.beginState.shallowCopy();
        if (this.evalFilterNode.getFactoryNode().getFilterSpec().getOptionalPropertyEvaluator() != null) {
            EventBean[] propertyEvents = this.evalFilterNode.getFactoryNode().getFilterSpec().getOptionalPropertyEvaluator().getProperty(theEvent, this.evalFilterNode.getContext().getAgentInstanceContext());
            if (propertyEvents == null) {
                return;
            }
            if (this.evalFilterNode.getFactoryNode().getEventAsName() != null) {
                passUp.add(this.evalFilterNode.getFactoryNode().getEventAsTagNumber(), propertyEvents);
            }
        } else if (this.evalFilterNode.getFactoryNode().getEventAsName() != null) {
            passUp.add(this.evalFilterNode.getFactoryNode().getEventAsTagNumber(), theEvent);
        }
        boolean isQuitted = false;
        if (!this.getParentEvaluator().isFilterChildNonQuitting()) {
            this.stopFiltering();
            isQuitted = true;
        }
        this.evaluateTrue(passUp, isQuitted, theEvent);
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitFilter(this.evalFilterNode.getFactoryNode(), this, this.handle, this.beginState);
    }

    @Override
    public boolean isSubSelect() {
        return false;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterStateNode");
        buffer.append(" tag=");
        buffer.append(this.evalFilterNode.getFactoryNode().getFilterSpec());
        buffer.append(" spec=");
        buffer.append(this.evalFilterNode.getFactoryNode().getFilterSpec());
        return buffer.toString();
    }

    @Override
    public boolean isFilterStateNode() {
        return true;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (!this.isStarted) {
            return;
        }
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            this.getParentEvaluator().evaluateFalse(this, true);
        }
    }

    protected void startFiltering() {
        FilterService filterService = this.evalFilterNode.getContext().getPatternContext().getFilterService();
        this.handle = new EPStatementHandleCallback(this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        AgentInstanceContext agentInstanceContext = this.evalFilterNode.getContext().getAgentInstanceContext();
        FilterValueSet filterValues = this.evalFilterNode.getFactoryNode().getFilterSpec().getValueSet(this.beginState, this.evalFilterNode.getAddendumFilters(), agentInstanceContext, agentInstanceContext.getEngineImportService(), agentInstanceContext.getAnnotations());
        this.filterServiceEntry = filterService.add(filterValues, this.handle);
        long filtersVersion = filterService.getFiltersVersion();
        this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }

    private void stopFiltering() {
        PatternContext context = this.evalFilterNode.getContext().getPatternContext();
        if (this.handle != null) {
            context.getFilterService().remove(this.handle, this.filterServiceEntry);
        }
        this.handle = null;
        this.filterServiceEntry = null;
        this.isStarted = false;
        long filtersVersion = context.getFilterService().getFiltersVersion();
        this.evalFilterNode.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }
}

