/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.filterspec.FilterAddendumUtil;
import com.espertech.esper.filterspec.FilterValueSetParam;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalFilterStateNode;
import com.espertech.esper.pattern.EvalFilterStateNodeConsumeImpl;
import com.espertech.esper.pattern.EvalNodeBase;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeNumber;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalFilterNode
extends EvalNodeBase {
    protected final EvalFilterFactoryNode factoryNode;
    private final FilterValueSetParam[][] addendumFilters;
    private static final Logger log = LoggerFactory.getLogger(EvalFilterNode.class);

    public EvalFilterNode(PatternAgentInstanceContext context, EvalFilterFactoryNode factoryNode) {
        super(context);
        FilterValueSetParam[][] contextAddendum;
        this.factoryNode = factoryNode;
        FilterValueSetParam[][] addendum = null;
        if (context.getAgentInstanceContext().getAgentInstanceFilterProxy() != null) {
            addendum = context.getAgentInstanceContext().getAgentInstanceFilterProxy().getAddendumFilters(factoryNode.getFilterSpec());
        }
        if (context.getFilterAddendum() != null && (contextAddendum = context.getFilterAddendum().get(factoryNode.getFilterSpec())) != null) {
            addendum = addendum == null ? contextAddendum : FilterAddendumUtil.multiplyAddendum(addendum, contextAddendum);
        }
        this.addendumFilters = addendum;
    }

    public EvalFilterFactoryNode getFactoryNode() {
        return this.factoryNode;
    }

    public FilterValueSetParam[][] getAddendumFilters() {
        return this.addendumFilters;
    }

    @Override
    public EvalStateNode newState(Evaluator parentNode, EvalStateNodeNumber stateNodeNumber, long stateNodeId) {
        if (this.getContext().getConsumptionHandler() != null) {
            return new EvalFilterStateNodeConsumeImpl(parentNode, this);
        }
        return new EvalFilterStateNode(parentNode, this);
    }
}

