/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.pattern.EvalEveryNode;
import com.espertech.esper.pattern.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.PatternConsumptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalEveryStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalEveryNode evalEveryNode;
    protected final List<EvalStateNode> spawnedNodes;
    protected MatchedEventMap beginState;
    private static final Logger log = LoggerFactory.getLogger(EvalEveryStateNode.class);

    public EvalEveryStateNode(Evaluator parentNode, EvalEveryNode evalEveryNode) {
        super(parentNode);
        this.evalEveryNode = evalEveryNode;
        this.spawnedNodes = new ArrayList<EvalStateNode>();
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            this.getParentEvaluator().evaluateFalse(this, true);
        } else {
            PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.spawnedNodes);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalEveryNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        this.beginState = beginState.shallowCopy();
        EvalStateNode childState = this.evalEveryNode.getChildNode().newState(this, null, 0L);
        this.spawnedNodes.add(childState);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getPatternContext().getStatementName());
        childState.setParentEvaluator(spawnEvaluator);
        childState.start(beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            childState.quit();
        } else {
            childState.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        if (!restartable) {
            this.getParentEvaluator().evaluateFalse(this, false);
            return;
        }
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getPatternContext().getStatementName());
        EvalStateNode spawned = this.evalEveryNode.getChildNode().newState(spawnEvaluator, null, 0L);
        spawned.start(this.beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.add(spawned);
            spawned.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!fromNode.isFilterStateNode() && !fromNode.isObserverStateNodeNonRestarting()) {
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.evalEveryNode.getContext().getPatternContext().getStatementName());
            EvalStateNode spawned = this.evalEveryNode.getChildNode().newState(spawnEvaluator, null, 0L);
            spawned.start(this.beginState);
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                this.spawnedNodes.add(spawned);
                spawned.setParentEvaluator(this);
            }
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, false, optionalTriggeringEvent);
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.spawnedNodes) {
            child.quit();
        }
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitEvery(this.evalEveryNode.getFactoryNode(), this, this.beginState, new Object[0]);
        for (EvalStateNode spawnedNode : this.spawnedNodes) {
            spawnedNode.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

