/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalEveryStateNode;
import com.espertech.esper.pattern.EvalEveryStateSpawnEvaluator;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.PatternConsumptionUtil;
import com.espertech.esper.pattern.PatternExpressionUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalEveryDistinctStateExpireKeyNode
extends EvalStateNode
implements Evaluator {
    protected final EvalEveryDistinctNode everyNode;
    protected final Map<EvalStateNode, LinkedHashMap<Object, Long>> spawnedNodes;
    protected MatchedEventMap beginState;
    private static final Logger log = LoggerFactory.getLogger(EvalEveryStateNode.class);

    public EvalEveryDistinctStateExpireKeyNode(Evaluator parentNode, EvalEveryDistinctNode everyNode) {
        super(parentNode);
        this.everyNode = everyNode;
        this.spawnedNodes = new LinkedHashMap<EvalStateNode, LinkedHashMap<Object, Long>>();
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            this.getParentEvaluator().evaluateFalse(this, true);
        } else {
            PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.spawnedNodes.keySet());
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.everyNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        this.beginState = beginState.shallowCopy();
        EvalStateNode childState = this.everyNode.getChildNode().newState(this, null, 0L);
        this.spawnedNodes.put(childState, new LinkedHashMap());
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getPatternContext().getStatementName());
        childState.setParentEvaluator(spawnEvaluator);
        childState.start(beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            childState.quit();
        } else {
            childState.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        fromNode.quit();
        this.spawnedNodes.remove(fromNode);
        EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getPatternContext().getStatementName());
        EvalStateNode spawned = this.everyNode.getChildNode().newState(spawnEvaluator, null, 0L);
        spawned.start(this.beginState);
        if (spawnEvaluator.isEvaluatedTrue()) {
            spawned.quit();
        } else {
            this.spawnedNodes.put(spawned, new LinkedHashMap());
            spawned.setParentEvaluator(this);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        Object matchEventKey = PatternExpressionUtil.getKeys(matchEvent, this.everyNode.getFactoryNode().getConvertor(), this.everyNode.getFactoryNode().getDistinctExpressionsArray(), this.everyNode.getContext().getAgentInstanceContext());
        boolean haveSeenThis = false;
        LinkedHashMap<Object, Long> keysFromNode = this.spawnedNodes.get(fromNode);
        if (keysFromNode != null) {
            Map.Entry<Object, Long> entry;
            Iterator<Map.Entry<Object, Long>> it = keysFromNode.entrySet().iterator();
            long currentTime = this.everyNode.getContext().getPatternContext().getTimeProvider().getTime();
            while (it.hasNext() && currentTime >= (entry = it.next()).getValue()) {
                it.remove();
            }
            if (keysFromNode.containsKey(matchEventKey)) {
                haveSeenThis = true;
            } else {
                long expiryTime = this.everyNode.getFactoryNode().absExpiry(this.everyNode.getContext());
                keysFromNode.put(matchEventKey, expiryTime);
            }
        }
        if (isQuitted) {
            this.spawnedNodes.remove(fromNode);
        }
        if (!fromNode.isFilterStateNode()) {
            EvalEveryStateSpawnEvaluator spawnEvaluator = new EvalEveryStateSpawnEvaluator(this.everyNode.getContext().getPatternContext().getStatementName());
            EvalStateNode spawned = this.everyNode.getChildNode().newState(spawnEvaluator, null, 0L);
            spawned.start(this.beginState);
            if (spawnEvaluator.isEvaluatedTrue()) {
                spawned.quit();
            } else {
                LinkedHashMap<Object, Long> keyset = new LinkedHashMap<Object, Long>();
                if (keysFromNode != null) {
                    keyset.putAll(keysFromNode);
                }
                this.spawnedNodes.put(spawned, keyset);
                spawned.setParentEvaluator(this);
            }
        }
        if (!haveSeenThis) {
            this.getParentEvaluator().evaluateTrue(matchEvent, this, false, optionalTriggeringEvent);
        }
    }

    @Override
    public final void quit() {
        for (EvalStateNode child : this.spawnedNodes.keySet()) {
            child.quit();
        }
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitEveryDistinct(this.everyNode.getFactoryNode(), this, this.beginState, this.spawnedNodes.values());
        for (EvalStateNode spawnedNode : this.spawnedNodes.keySet()) {
            spawnedNode.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalEveryStateNode spawnedChildren=" + this.spawnedNodes.size();
    }
}

