/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.metrics.instrumentation;

import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.core.service.EPServiceProviderSPI;
import com.espertech.esper.metrics.instrumentation.Instrumentation;
import com.espertech.esper.metrics.instrumentation.InstrumentationAssertionService;
import com.espertech.esper.metrics.instrumentation.InstrumentationDefault;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Locale;

public class InstrumentationHelper {
    private static final String PROVIDER_PROPERTY = "instrumentation_provider";
    public static final boolean ENABLED = false;
    public static final boolean ASSERTIONENABLED = false;
    public static Instrumentation defaultInstrumentation;
    public static Instrumentation instrumentation;
    public static InstrumentationAssertionService assertionService;

    public static Instrumentation get() {
        return instrumentation;
    }

    public static void startTest(EPServiceProvider engine, Class testClass, String testName) {
    }

    public static void endTest() {
    }

    private static void resolveAssertionService(EPServiceProvider epServiceProvider) {
        String provider = System.getProperty(PROVIDER_PROPERTY);
        if (provider == null) {
            throw new RuntimeException("Failed to find 'instrumentation_provider' system property");
        }
        if (provider.toLowerCase(Locale.ENGLISH).trim().equals("default")) {
            assertionService = new DefaultInstrumentationAssertionService();
        } else {
            EPServiceProviderSPI spi = (EPServiceProviderSPI)epServiceProvider;
            assertionService = (InstrumentationAssertionService)JavaClassHelper.instantiate(InstrumentationAssertionService.class, provider, spi.getEngineImportService().getClassForNameProvider());
        }
    }

    static {
        instrumentation = defaultInstrumentation = new InstrumentationDefault();
    }

    private static class DefaultInstrumentationAssertionService
    implements InstrumentationAssertionService {
        private DefaultInstrumentationAssertionService() {
        }

        @Override
        public void startTest(EPServiceProvider engine, Class testClass, String testName) {
        }

        @Override
        public void endTest() {
        }
    }
}

