/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filterspec;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.filterspec.ExprNodeAdapterBase;
import com.espertech.esper.filterspec.FilterBooleanExpressionFactory;
import com.espertech.esper.filterspec.FilterOperator;
import com.espertech.esper.filterspec.FilterSpecParam;
import com.espertech.esper.filterspec.MatchedEventMap;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FilterSpecParamExprNode
extends FilterSpecParam {
    private final ExprNode exprNode;
    private final LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;
    private final transient EventAdapterService eventAdapterService;
    private final transient FilterBooleanExpressionFactory filterBooleanExpressionFactory;
    private final transient VariableService variableService;
    private final transient TableService tableService;
    private final boolean hasVariable;
    private final boolean useLargeThreadingProfile;
    private final boolean hasFilterStreamSubquery;
    private final boolean hasTableAccess;
    private int filterSpecId;
    private int filterSpecParamPathNum;
    private static final long serialVersionUID = 2298436088557677833L;

    public FilterSpecParamExprNode(ExprFilterSpecLookupable lookupable, FilterOperator filterOperator, ExprNode exprNode, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, VariableService variableService, TableService tableService, EventAdapterService eventAdapterService, FilterBooleanExpressionFactory filterBooleanExpressionFactory, ConfigurationEngineDefaults.ThreadingProfile threadingProfile, boolean hasSubquery, boolean hasTableAccess, boolean hasVariable) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        if (filterOperator != FilterOperator.BOOLEAN_EXPRESSION) {
            throw new IllegalArgumentException("Invalid filter operator for filter expression node");
        }
        this.exprNode = exprNode;
        this.taggedEventTypes = taggedEventTypes;
        this.arrayEventTypes = arrayEventTypes;
        this.variableService = variableService;
        this.tableService = tableService;
        this.eventAdapterService = eventAdapterService;
        this.filterBooleanExpressionFactory = filterBooleanExpressionFactory;
        this.useLargeThreadingProfile = threadingProfile == ConfigurationEngineDefaults.ThreadingProfile.LARGE;
        this.hasFilterStreamSubquery = hasSubquery;
        this.hasTableAccess = hasTableAccess;
        this.hasVariable = hasVariable;
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }

    public LinkedHashMap<String, Pair<EventType, String>> getTaggedEventTypes() {
        return this.taggedEventTypes;
    }

    @Override
    public final ExprNodeAdapterBase getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext, EngineImportService engineImportService, Annotation[] annotations) {
        EventBean[] events = null;
        if (this.taggedEventTypes != null && !this.taggedEventTypes.isEmpty() || this.arrayEventTypes != null && !this.arrayEventTypes.isEmpty()) {
            int size = 0;
            size += this.taggedEventTypes != null ? this.taggedEventTypes.size() : 0;
            events = new EventBean[(size += this.arrayEventTypes != null ? this.arrayEventTypes.size() : 0) + 1];
            int count = 1;
            if (this.taggedEventTypes != null) {
                for (String string : this.taggedEventTypes.keySet()) {
                    events[count] = matchedEvents.getMatchingEventByTag(string);
                    ++count;
                }
            }
            if (this.arrayEventTypes != null) {
                for (Map.Entry entry : this.arrayEventTypes.entrySet()) {
                    EventType compositeEventType = (EventType)((Pair)entry.getValue()).getFirst();
                    events[count] = this.eventAdapterService.adapterForTypedMap(matchedEvents.getMatchingEventsAsMap(), compositeEventType);
                    ++count;
                }
            }
        }
        return this.filterBooleanExpressionFactory.make(this, events, exprEvaluatorContext, exprEvaluatorContext.getAgentInstanceId(), engineImportService, annotations);
    }

    @Override
    public final String toString() {
        return super.toString() + "  exprNode=" + this.exprNode.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamExprNode)) {
            return false;
        }
        FilterSpecParamExprNode other = (FilterSpecParamExprNode)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.exprNode == other.exprNode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.exprNode.hashCode();
        return result;
    }

    public int getFilterSpecId() {
        return this.filterSpecId;
    }

    public void setFilterSpecId(int filterSpecId) {
        this.filterSpecId = filterSpecId;
    }

    public int getFilterSpecParamPathNum() {
        return this.filterSpecParamPathNum;
    }

    public void setFilterSpecParamPathNum(int filterSpecParamPathNum) {
        this.filterSpecParamPathNum = filterSpecParamPathNum;
    }

    public LinkedHashMap<String, Pair<EventType, String>> getArrayEventTypes() {
        return this.arrayEventTypes;
    }

    public EventAdapterService getEventAdapterService() {
        return this.eventAdapterService;
    }

    public FilterBooleanExpressionFactory getFilterBooleanExpressionFactory() {
        return this.filterBooleanExpressionFactory;
    }

    public VariableService getVariableService() {
        return this.variableService;
    }

    public TableService getTableService() {
        return this.tableService;
    }

    public boolean isHasVariable() {
        return this.hasVariable;
    }

    public boolean isUseLargeThreadingProfile() {
        return this.useLargeThreadingProfile;
    }

    public boolean isHasFilterStreamSubquery() {
        return this.hasFilterStreamSubquery;
    }

    public boolean isHasTableAccess() {
        return this.hasTableAccess;
    }
}

