/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filterspec;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.filterspec.FilterAddendumUtil;
import com.espertech.esper.filterspec.FilterSpecParam;
import com.espertech.esper.filterspec.FilterSpecParamComparator;
import com.espertech.esper.filterspec.FilterValueSet;
import com.espertech.esper.filterspec.FilterValueSetImpl;
import com.espertech.esper.filterspec.FilterValueSetParam;
import com.espertech.esper.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.filterspec.PropertyEvaluator;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class FilterSpecCompiled {
    private static final FilterSpecParamComparator COMPARATOR_PARAMETERS = new FilterSpecParamComparator();
    private final EventType filterForEventType;
    private final String filterForEventTypeName;
    private final FilterSpecParam[][] parameters;
    private final PropertyEvaluator optionalPropertyEvaluator;

    public FilterSpecCompiled(EventType eventType, String eventTypeName, List<FilterSpecParam>[] filterParameters, PropertyEvaluator optionalPropertyEvaluator) {
        this.filterForEventType = eventType;
        this.filterForEventTypeName = eventTypeName;
        this.parameters = FilterSpecCompiled.sortRemoveDups(filterParameters);
        this.optionalPropertyEvaluator = optionalPropertyEvaluator;
    }

    public final EventType getFilterForEventType() {
        return this.filterForEventType;
    }

    public final FilterSpecParam[][] getParameters() {
        return this.parameters;
    }

    public String getFilterForEventTypeName() {
        return this.filterForEventTypeName;
    }

    public PropertyEvaluator getOptionalPropertyEvaluator() {
        return this.optionalPropertyEvaluator;
    }

    public EventType getResultEventType() {
        if (this.optionalPropertyEvaluator != null) {
            return this.optionalPropertyEvaluator.getFragmentEventType();
        }
        return this.filterForEventType;
    }

    public FilterValueSet getValueSet(MatchedEventMap matchedEvents, FilterValueSetParam[][] addendum, ExprEvaluatorContext exprEvaluatorContext, EngineImportService engineImportService, Annotation[] annotations) {
        FilterValueSetParam[][] valueList = new FilterValueSetParam[this.parameters.length][];
        for (int i = 0; i < this.parameters.length; ++i) {
            valueList[i] = new FilterValueSetParam[this.parameters[i].length];
            FilterSpecCompiled.populateValueSet(valueList[i], matchedEvents, this.parameters[i], exprEvaluatorContext, engineImportService, annotations);
        }
        if (addendum != null) {
            valueList = FilterAddendumUtil.multiplyAddendum(addendum, valueList);
        }
        return new FilterValueSetImpl(this.filterForEventType, valueList);
    }

    private static void populateValueSet(FilterValueSetParam[] valueList, MatchedEventMap matchedEvents, FilterSpecParam[] specParams, ExprEvaluatorContext exprEvaluatorContext, EngineImportService engineImportService, Annotation[] annotations) {
        int count = 0;
        for (FilterSpecParam specParam : specParams) {
            Object filterForValue = specParam.getFilterValue(matchedEvents, exprEvaluatorContext, engineImportService, annotations);
            FilterValueSetParamImpl valueParam = new FilterValueSetParamImpl(specParam.getLookupable(), specParam.getFilterOperator(), filterForValue);
            valueList[count] = valueParam;
            ++count;
        }
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecCompiled type=" + this.filterForEventType);
        buffer.append(" parameters=" + Arrays.toString((Object[])this.parameters));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecCompiled)) {
            return false;
        }
        FilterSpecCompiled other = (FilterSpecCompiled)obj;
        if (!this.equalsTypeAndFilter(other)) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator == null) {
            return true;
        }
        if (this.optionalPropertyEvaluator != null && other.optionalPropertyEvaluator == null) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator != null) {
            return false;
        }
        return this.optionalPropertyEvaluator.compareTo(other.optionalPropertyEvaluator);
    }

    public boolean equalsTypeAndFilter(FilterSpecCompiled other) {
        if (this.filterForEventType != other.filterForEventType) {
            return false;
        }
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            FilterSpecParam[] lineThis = this.parameters[i];
            FilterSpecParam[] lineOther = other.parameters[i];
            if (lineThis.length != lineOther.length) {
                return false;
            }
            for (int j = 0; j < lineThis.length; ++j) {
                if (lineThis[j].equals(lineOther[j])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.filterForEventType.hashCode();
        FilterSpecParam[][] filterSpecParamArray = this.parameters;
        int n = filterSpecParamArray.length;
        for (int i = 0; i < n; ++i) {
            FilterSpecParam[] paramLine;
            for (FilterSpecParam param : paramLine = filterSpecParamArray[i]) {
                hashCode ^= 31 * param.hashCode();
            }
        }
        return hashCode;
    }

    public int getFilterSpecIndexAmongAll(FilterSpecCompiled[] filterSpecAll) {
        for (int i = 0; i < filterSpecAll.length; ++i) {
            if (this != filterSpecAll[i]) continue;
            return i;
        }
        throw new EPException("Failed to find find filter spec among list of known filters");
    }

    protected static FilterSpecParam[][] sortRemoveDups(List<FilterSpecParam>[] parameters) {
        FilterSpecParam[][] processed = new FilterSpecParam[parameters.length][];
        for (int i = 0; i < parameters.length; ++i) {
            processed[i] = FilterSpecCompiled.sortRemoveDups(parameters[i]);
        }
        return processed;
    }

    protected static FilterSpecParam[] sortRemoveDups(List<FilterSpecParam> parameters) {
        if (parameters.isEmpty()) {
            return FilterSpecParam.EMPTY_PARAM_ARRAY;
        }
        if (parameters.size() == 1) {
            return new FilterSpecParam[]{parameters.get(0)};
        }
        ArrayDeque<FilterSpecParam> result = new ArrayDeque<FilterSpecParam>();
        TreeMap map = new TreeMap(COMPARATOR_PARAMETERS);
        for (FilterSpecParam filterSpecParam : parameters) {
            ArrayList<FilterSpecParam> list = (ArrayList<FilterSpecParam>)map.get((Object)filterSpecParam.getFilterOperator());
            if (list == null) {
                list = new ArrayList<FilterSpecParam>();
                map.put(filterSpecParam.getFilterOperator(), list);
            }
            boolean hasDuplicate = false;
            for (FilterSpecParam existing : list) {
                if (!existing.getLookupable().equals(filterSpecParam.getLookupable())) continue;
                hasDuplicate = true;
                break;
            }
            if (hasDuplicate) continue;
            list.add(filterSpecParam);
        }
        for (Map.Entry entry : map.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        return FilterSpecParam.toArray(result);
    }
}

