/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filterspec;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeAdapterBase {
    private static final Logger log = LoggerFactory.getLogger(ExprNodeAdapterBase.class);
    private final int filterSpecId;
    private final int filterSpecParamPathNum;
    protected final ExprNode exprNode;
    protected final ExprEvaluator exprNodeEval;
    protected final ExprEvaluatorContext evaluatorContext;

    public ExprNodeAdapterBase(int filterSpecId, int filterSpecParamPathNum, ExprNode exprNode, ExprEvaluator exprEvaluator, ExprEvaluatorContext evaluatorContext, EngineImportService engineImportService) {
        this.filterSpecId = filterSpecId;
        this.filterSpecParamPathNum = filterSpecParamPathNum;
        this.exprNode = exprNode;
        this.exprNodeEval = exprEvaluator;
        this.evaluatorContext = evaluatorContext;
    }

    public boolean evaluate(EventBean theEvent) {
        return this.evaluatePerStream(new EventBean[]{theEvent});
    }

    protected boolean evaluatePerStream(EventBean[] eventsPerStream) {
        try {
            Boolean result = (Boolean)this.exprNodeEval.evaluate(eventsPerStream, true, this.evaluatorContext);
            if (result == null) {
                return false;
            }
            return result;
        }
        catch (RuntimeException ex) {
            String message = "Error evaluating expression '" + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(this.exprNode) + "' statement '" + this.getStatementName() + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new EPException(message, ex);
        }
    }

    public String getStatementName() {
        return this.evaluatorContext.getStatementName();
    }

    public int getStatementId() {
        return this.evaluatorContext.getStatementId();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }

    public int getFilterSpecId() {
        return this.filterSpecId;
    }

    public int getFilterSpecParamPathNum() {
        return this.filterSpecParamPathNum;
    }

    public ExprEvaluatorContext getEvaluatorContext() {
        return this.evaluatorContext;
    }
}

