/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.epl.index.quadtree.AdvancedIndexConfigContextPartitionQuadTree;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filter.FilterSpecLookupableAdvancedIndex;
import com.espertech.esper.filterspec.FilterOperator;
import com.espertech.esper.spatial.quadtree.core.QuadTreeCollector;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTreeFactory;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexCollect;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexCount;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexDelete;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexEmpty;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexGet;
import com.espertech.esper.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexSet;
import com.espertech.esper.type.XYPoint;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;

public class FilterParamIndexQuadTreePointRegion
extends FilterParamIndexLookupableBase {
    private final ReadWriteLock readWriteLock;
    private final PointRegionQuadTree<Object> quadTree;
    private final FilterSpecLookupableAdvancedIndex advancedIndex;
    private static final QuadTreeCollector<EventEvaluator, Collection<FilterHandle>> COLLECTOR = new QuadTreeCollector<EventEvaluator, Collection<FilterHandle>>(){

        @Override
        public void collectInto(EventBean event, EventEvaluator eventEvaluator, Collection<FilterHandle> c) {
            eventEvaluator.matchEvent(event, c);
        }
    };

    public FilterParamIndexQuadTreePointRegion(ReadWriteLock readWriteLock, ExprFilterSpecLookupable lookupable) {
        super(FilterOperator.ADVANCED_INDEX, lookupable);
        this.readWriteLock = readWriteLock;
        this.advancedIndex = (FilterSpecLookupableAdvancedIndex)lookupable;
        AdvancedIndexConfigContextPartitionQuadTree quadTreeConfig = this.advancedIndex.getQuadTreeConfig();
        this.quadTree = PointRegionQuadTreeFactory.make(quadTreeConfig.getX(), quadTreeConfig.getY(), quadTreeConfig.getWidth(), quadTreeConfig.getHeight());
    }

    @Override
    public void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        double x = ((Number)this.advancedIndex.getX().get(theEvent)).doubleValue();
        double y = ((Number)this.advancedIndex.getY().get(theEvent)).doubleValue();
        double width = ((Number)this.advancedIndex.getWidth().get(theEvent)).doubleValue();
        double height = ((Number)this.advancedIndex.getHeight().get(theEvent)).doubleValue();
        PointRegionQuadTreeFilterIndexCollect.collectRange(this.quadTree, x, y, width, height, theEvent, matches, COLLECTOR);
    }

    @Override
    public EventEvaluator get(Object filterConstant) {
        XYPoint point = (XYPoint)filterConstant;
        return (EventEvaluator)PointRegionQuadTreeFilterIndexGet.get(point.getX(), point.getY(), this.quadTree);
    }

    @Override
    public void put(Object filterConstant, EventEvaluator evaluator) {
        XYPoint point = (XYPoint)filterConstant;
        PointRegionQuadTreeFilterIndexSet.set(point.getX(), point.getY(), evaluator, this.quadTree);
    }

    @Override
    public void remove(Object filterConstant) {
        XYPoint point = (XYPoint)filterConstant;
        PointRegionQuadTreeFilterIndexDelete.delete(point.getX(), point.getY(), this.quadTree);
    }

    @Override
    public int sizeExpensive() {
        return PointRegionQuadTreeFilterIndexCount.count(this.quadTree);
    }

    @Override
    public boolean isEmpty() {
        return PointRegionQuadTreeFilterIndexEmpty.isEmpty(this.quadTree);
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

