/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.epl.index.quadtree.AdvancedIndexConfigContextPartitionQuadTree;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filter.FilterSpecLookupableAdvancedIndex;
import com.espertech.esper.filterspec.FilterOperator;
import com.espertech.esper.spatial.quadtree.core.QuadTreeCollector;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeFactory;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.MXCIFQuadTreeFilterIndexCollect;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.MXCIFQuadTreeFilterIndexCount;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.MXCIFQuadTreeFilterIndexDelete;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.MXCIFQuadTreeFilterIndexEmpty;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.MXCIFQuadTreeFilterIndexGet;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.MXCIFQuadTreeFilterIndexSet;
import com.espertech.esper.type.XYWHRectangle;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;

public class FilterParamIndexQuadTreeMXCIF
extends FilterParamIndexLookupableBase {
    private final ReadWriteLock readWriteLock;
    private final MXCIFQuadTree<Object> quadTree;
    private final FilterSpecLookupableAdvancedIndex advancedIndex;
    private static final QuadTreeCollector<EventEvaluator, Collection<FilterHandle>> COLLECTOR = new QuadTreeCollector<EventEvaluator, Collection<FilterHandle>>(){

        @Override
        public void collectInto(EventBean event, EventEvaluator eventEvaluator, Collection<FilterHandle> c) {
            eventEvaluator.matchEvent(event, c);
        }
    };

    public FilterParamIndexQuadTreeMXCIF(ReadWriteLock readWriteLock, ExprFilterSpecLookupable lookupable) {
        super(FilterOperator.ADVANCED_INDEX, lookupable);
        this.readWriteLock = readWriteLock;
        this.advancedIndex = (FilterSpecLookupableAdvancedIndex)lookupable;
        AdvancedIndexConfigContextPartitionQuadTree quadTreeConfig = this.advancedIndex.getQuadTreeConfig();
        this.quadTree = MXCIFQuadTreeFactory.make(quadTreeConfig.getX(), quadTreeConfig.getY(), quadTreeConfig.getWidth(), quadTreeConfig.getHeight());
    }

    @Override
    public void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        double x = ((Number)this.advancedIndex.getX().get(theEvent)).doubleValue();
        double y = ((Number)this.advancedIndex.getY().get(theEvent)).doubleValue();
        double width = ((Number)this.advancedIndex.getWidth().get(theEvent)).doubleValue();
        double height = ((Number)this.advancedIndex.getHeight().get(theEvent)).doubleValue();
        MXCIFQuadTreeFilterIndexCollect.collectRange(this.quadTree, x, y, width, height, theEvent, matches, COLLECTOR);
    }

    @Override
    public EventEvaluator get(Object filterConstant) {
        XYWHRectangle rect = (XYWHRectangle)filterConstant;
        return (EventEvaluator)MXCIFQuadTreeFilterIndexGet.get(rect.getX(), rect.getY(), rect.getW(), rect.getH(), this.quadTree);
    }

    @Override
    public void put(Object filterConstant, EventEvaluator evaluator) {
        XYWHRectangle rect = (XYWHRectangle)filterConstant;
        MXCIFQuadTreeFilterIndexSet.set(rect.getX(), rect.getY(), rect.getW(), rect.getH(), evaluator, this.quadTree);
    }

    @Override
    public void remove(Object filterConstant) {
        XYWHRectangle rect = (XYWHRectangle)filterConstant;
        MXCIFQuadTreeFilterIndexDelete.delete(rect.getX(), rect.getY(), rect.getW(), rect.getH(), this.quadTree);
    }

    @Override
    public int sizeExpensive() {
        return MXCIFQuadTreeFilterIndexCount.count(this.quadTree);
    }

    @Override
    public boolean isEmpty() {
        return MXCIFQuadTreeFilterIndexEmpty.isEmpty(this.quadTree);
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

