/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.filter.DoubleRangeComparator;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filterspec.DoubleRange;
import com.espertech.esper.filterspec.FilterOperator;
import java.util.IdentityHashMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterParamIndexDoubleRangeBase
extends FilterParamIndexLookupableBase {
    protected final TreeMap<DoubleRange, EventEvaluator> ranges;
    private final IdentityHashMap<DoubleRange, EventEvaluator> rangesNullEndpoints;
    private final ReadWriteLock rangesRWLock;
    protected double largestRangeValueDouble = Double.MIN_VALUE;
    private static final Logger log = LoggerFactory.getLogger(FilterParamIndexDoubleRangeBase.class);

    protected FilterParamIndexDoubleRangeBase(ExprFilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(filterOperator, lookupable);
        this.ranges = new TreeMap(new DoubleRangeComparator());
        this.rangesNullEndpoints = new IdentityHashMap();
        this.rangesRWLock = readWriteLock;
    }

    @Override
    public final EventEvaluator get(Object expressionValue) {
        if (!(expressionValue instanceof DoubleRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        DoubleRange range = (DoubleRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            return this.rangesNullEndpoints.get(range);
        }
        return this.ranges.get(range);
    }

    @Override
    public final void put(Object expressionValue, EventEvaluator matcher) {
        if (!(expressionValue instanceof DoubleRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        DoubleRange range = (DoubleRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            this.rangesNullEndpoints.put(range, matcher);
            return;
        }
        if (Math.abs(range.getMax() - range.getMin()) > this.largestRangeValueDouble) {
            this.largestRangeValueDouble = Math.abs(range.getMax() - range.getMin());
        }
        this.ranges.put(range, matcher);
    }

    @Override
    public final void remove(Object filterConstant) {
        DoubleRange range = (DoubleRange)filterConstant;
        if (range.getMax() == null || range.getMin() == null) {
            this.rangesNullEndpoints.remove(range);
            return;
        }
        this.ranges.remove(range);
    }

    @Override
    public final int sizeExpensive() {
        return this.ranges.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.rangesRWLock;
    }
}

