/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.filterspec.FilterSpecParamFilterForEvalDouble;
import com.espertech.esper.filterspec.MatchedEventMap;

public class FilterForEvalEventPropDouble
implements FilterSpecParamFilterForEvalDouble {
    private final String resultEventAsName;
    private final String resultEventProperty;
    private static final long serialVersionUID = 3372433556541547809L;

    public FilterForEvalEventPropDouble(String resultEventAsName, String resultEventProperty) {
        this.resultEventAsName = resultEventAsName;
        this.resultEventProperty = resultEventProperty;
    }

    @Override
    public Double getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = matchedEvents.getMatchingEventByTag(this.resultEventAsName);
        if (theEvent == null) {
            throw new IllegalStateException("Matching event named '" + this.resultEventAsName + "' not found in event result set");
        }
        Number value = (Number)theEvent.get(this.resultEventProperty);
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    @Override
    public Double getFilterValueDouble(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        return this.getFilterValue(matchedEvents, exprEvaluatorContext);
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public final String toString() {
        return "resultEventProp=" + this.resultEventAsName + '.' + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterForEvalEventPropDouble)) {
            return false;
        }
        FilterForEvalEventPropDouble other = (FilterForEvalEventPropDouble)obj;
        return other.resultEventAsName.equals(this.resultEventAsName) && other.resultEventProperty.equals(this.resultEventProperty);
    }

    public int hashCode() {
        return this.resultEventProperty.hashCode();
    }
}

