/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariantPropertyGetterCache {
    private volatile EventType[] knownTypes;
    private volatile VariantPropertyGetterRow lastUsedGetters;
    private List<String> properties;
    private Map<EventType, VariantPropertyGetterRow> allGetters;

    public VariantPropertyGetterCache(EventType[] knownTypes) {
        this.knownTypes = knownTypes;
        this.allGetters = new HashMap<EventType, VariantPropertyGetterRow>();
        this.properties = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGetters(int assignedPropertyNumber, String propertyName) {
        for (EventType type : this.knownTypes) {
            EventPropertyGetter getter = type.getGetter(propertyName);
            VariantPropertyGetterRow row = this.allGetters.get(type);
            if (row == null) {
                VariantPropertyGetterCache variantPropertyGetterCache = this;
                synchronized (variantPropertyGetterCache) {
                    row = new VariantPropertyGetterRow(type, new EventPropertyGetter[assignedPropertyNumber + 1]);
                    this.allGetters.put(type, row);
                }
            }
            row.addGetter(assignedPropertyNumber, getter);
        }
        this.properties.add(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventPropertyGetter getGetter(int assignedPropertyNumber, EventType eventType) {
        VariantPropertyGetterRow lastGetters = this.lastUsedGetters;
        if (lastGetters != null && lastGetters.eventType == eventType) {
            return lastGetters.getGetterPerProp()[assignedPropertyNumber];
        }
        VariantPropertyGetterRow row = this.allGetters.get(eventType);
        if (row == null) {
            VariantPropertyGetterCache variantPropertyGetterCache = this;
            synchronized (variantPropertyGetterCache) {
                row = this.allGetters.get(eventType);
                if (row == null) {
                    row = this.addType(eventType);
                }
            }
        }
        EventPropertyGetter getter = row.getGetterPerProp()[assignedPropertyNumber];
        this.lastUsedGetters = row;
        return getter;
    }

    private VariantPropertyGetterRow addType(EventType eventType) {
        EventType[] newKnownTypes = (EventType[])VariantPropertyGetterCache.resizeArray(this.knownTypes, this.knownTypes.length + 1);
        newKnownTypes[newKnownTypes.length - 1] = eventType;
        EventPropertyGetter[] getters = new EventPropertyGetter[this.properties.size()];
        for (int i = 0; i < this.properties.size(); ++i) {
            getters[i] = eventType.getGetter(this.properties.get(i));
        }
        VariantPropertyGetterRow row = new VariantPropertyGetterRow(eventType, getters);
        HashMap<EventType, VariantPropertyGetterRow> newAllGetters = new HashMap<EventType, VariantPropertyGetterRow>();
        newAllGetters.putAll(this.allGetters);
        newAllGetters.put(eventType, row);
        this.knownTypes = newKnownTypes;
        this.allGetters = newAllGetters;
        return row;
    }

    private static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    private static class VariantPropertyGetterRow {
        private EventType eventType;
        private EventPropertyGetter[] getterPerProp;

        private VariantPropertyGetterRow(EventType eventType, EventPropertyGetter[] getterPerProp) {
            this.eventType = eventType;
            this.getterPerProp = getterPerProp;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public EventPropertyGetter[] getGetterPerProp() {
            return this.getterPerProp;
        }

        public void setGetterPerProp(EventPropertyGetter[] getterPerProp) {
            this.getterPerProp = getterPerProp;
        }

        public void addGetter(int assignedPropertyNumber, EventPropertyGetter getter) {
            if (assignedPropertyNumber > this.getterPerProp.length - 1) {
                this.getterPerProp = (EventPropertyGetter[])VariantPropertyGetterCache.resizeArray(this.getterPerProp, this.getterPerProp.length + 10);
            }
            this.getterPerProp[assignedPropertyNumber] = getter;
        }
    }
}

