/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.lookup.EventTableIndexRepository;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.event.vaevent.VariantEventBean;
import com.espertech.esper.event.vaevent.VariantEventType;
import com.espertech.esper.event.vaevent.VariantPropResolutionStrategy;
import com.espertech.esper.event.vaevent.VariantPropResolutionStrategyAny;
import com.espertech.esper.event.vaevent.VariantPropResolutionStrategyDefault;
import com.espertech.esper.event.vaevent.VariantSpec;
import com.espertech.esper.view.Viewable;
import java.util.Collection;
import java.util.Iterator;

public class VAEVariantProcessor
implements ValueAddEventProcessor {
    protected final VariantSpec variantSpec;
    protected VariantEventType variantEventType;

    public VAEVariantProcessor(EventAdapterService eventAdapterService, VariantSpec variantSpec, EventTypeIdGenerator eventTypeIdGenerator, ConfigurationVariantStream config) {
        this.variantSpec = variantSpec;
        VariantPropResolutionStrategy strategy = variantSpec.getTypeVariance() == ConfigurationVariantStream.TypeVariance.ANY ? new VariantPropResolutionStrategyAny(variantSpec) : new VariantPropResolutionStrategyDefault(variantSpec);
        EventTypeMetadata metadata = EventTypeMetadata.createValueAdd(variantSpec.getVariantStreamName(), EventTypeMetadata.TypeClass.VARIANT);
        this.variantEventType = new VariantEventType(eventAdapterService, metadata, eventTypeIdGenerator.getTypeId(variantSpec.getVariantStreamName()), variantSpec, strategy, config);
    }

    @Override
    public EventType getValueAddEventType() {
        return this.variantEventType;
    }

    @Override
    public void validateEventType(EventType eventType) throws ExprValidationException {
        if (this.variantSpec.getTypeVariance() == ConfigurationVariantStream.TypeVariance.ANY) {
            return;
        }
        if (eventType == null) {
            throw new ExprValidationException(this.getMessage());
        }
        for (EventType variant : this.variantSpec.getEventTypes()) {
            if (variant != eventType) continue;
            return;
        }
        for (EventType variant : this.variantSpec.getEventTypes()) {
            Iterator<EventType> deepSupers = eventType.getDeepSuperTypes();
            if (deepSupers == null) continue;
            while (deepSupers.hasNext()) {
                EventType superType = deepSupers.next();
                if (superType != variant) continue;
                return;
            }
        }
        throw new ExprValidationException(this.getMessage());
    }

    @Override
    public EventBean getValueAddEventBean(EventBean theEvent) {
        return new VariantEventBean(this.variantEventType, theEvent);
    }

    @Override
    public void onUpdate(EventBean[] newData, EventBean[] oldData, NamedWindowRootViewInstance namedWindowRootView, EventTableIndexRepository indexRepository) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<EventBean> getSnapshot(EPStatementAgentInstanceHandle createWindowStmtHandle, Viewable parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOldData(EventBean[] oldData, EventTableIndexRepository indexRepository, AgentInstanceContext agentInstanceContext) {
        throw new UnsupportedOperationException();
    }

    private String getMessage() {
        return "Selected event type is not a valid event type of the variant stream '" + this.variantSpec.getVariantStreamName() + "'";
    }
}

