/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.util.EventPropertyRenderer;
import com.espertech.esper.client.util.EventPropertyRendererContext;
import com.espertech.esper.client.util.JSONEventRenderer;
import com.espertech.esper.client.util.JSONRenderingOptions;
import com.espertech.esper.event.util.EventTypePropertyPair;
import com.espertech.esper.event.util.GetterPair;
import com.espertech.esper.event.util.NestedGetterPair;
import com.espertech.esper.event.util.OutputValueRenderer;
import com.espertech.esper.event.util.OutputValueRendererFactory;
import com.espertech.esper.event.util.RendererMeta;
import com.espertech.esper.event.util.RendererMetaOptions;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRendererImpl
implements JSONEventRenderer {
    private static final Logger log = LoggerFactory.getLogger(JSONRendererImpl.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String COMMA_DELIMITER_NEWLINE = "," + NEWLINE;
    private final RendererMeta meta;
    private final RendererMetaOptions rendererOptions;

    public JSONRendererImpl(EventType eventType, JSONRenderingOptions options) {
        EventPropertyRenderer propertyRenderer = null;
        EventPropertyRendererContext propertyRendererContext = null;
        if (options.getRenderer() != null) {
            propertyRenderer = options.getRenderer();
            propertyRendererContext = new EventPropertyRendererContext(eventType, true);
        }
        this.rendererOptions = new RendererMetaOptions(options.isPreventLooping(), false, propertyRenderer, propertyRendererContext);
        this.meta = new RendererMeta(eventType, new Stack<EventTypePropertyPair>(), this.rendererOptions);
    }

    @Override
    public String render(String title, EventBean theEvent) {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        buf.append(NEWLINE);
        JSONRendererImpl.ident(buf, 1);
        buf.append('\"');
        buf.append(title);
        buf.append("\": {");
        buf.append(NEWLINE);
        JSONRendererImpl.recursiveRender(theEvent, buf, 2, this.meta, this.rendererOptions);
        JSONRendererImpl.ident(buf, 1);
        buf.append('}');
        buf.append(NEWLINE);
        buf.append('}');
        buf.append(NEWLINE);
        return buf.toString();
    }

    @Override
    public String render(EventBean theEvent) {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        JSONRendererImpl.recursiveRender(theEvent, buf, 2, this.meta, this.rendererOptions);
        buf.append('}');
        return buf.toString();
    }

    private static void ident(StringBuilder buf, int level) {
        for (int i = 0; i < level; ++i) {
            JSONRendererImpl.indentChar(buf);
        }
    }

    private static void indentChar(StringBuilder buf) {
        buf.append(' ');
        buf.append(' ');
    }

    private static void recursiveRender(EventBean theEvent, StringBuilder buf, int level, RendererMeta meta, RendererMetaOptions rendererOptions) {
        NestedGetterPair[] nestedProps;
        GetterPair[] mappedProps;
        GetterPair[] indexProps;
        Object value;
        String delimiter = "";
        GetterPair[] simpleProps = meta.getSimpleProperties();
        if (rendererOptions.getRenderer() == null) {
            for (GetterPair simpleProp : simpleProps) {
                Object value2 = simpleProp.getGetter().get(theEvent);
                JSONRendererImpl.writeDelimitedIndentedProp(buf, delimiter, level, simpleProp.getName());
                simpleProp.getOutput().render(value2, buf);
                delimiter = COMMA_DELIMITER_NEWLINE;
            }
        } else {
            EventPropertyRendererContext context = rendererOptions.getRendererContext();
            context.setStringBuilderAndReset(buf);
            for (GetterPair simpleProp : simpleProps) {
                value = simpleProp.getGetter().get(theEvent);
                JSONRendererImpl.writeDelimitedIndentedProp(buf, delimiter, level, simpleProp.getName());
                context.setDefaultRenderer(simpleProp.getOutput());
                context.setPropertyName(simpleProp.getName());
                context.setPropertyValue(value);
                rendererOptions.getRenderer().render(context);
                delimiter = COMMA_DELIMITER_NEWLINE;
            }
        }
        for (GetterPair indexProp : indexProps = meta.getIndexProperties()) {
            value = indexProp.getGetter().get(theEvent);
            JSONRendererImpl.writeDelimitedIndentedProp(buf, delimiter, level, indexProp.getName());
            if (value == null) {
                buf.append("null");
            } else if (!value.getClass().isArray()) {
                buf.append("[]");
            } else {
                buf.append('[');
                String arrayDelimiter = "";
                if (rendererOptions.getRenderer() == null) {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object arrayItem = Array.get(value, i);
                        buf.append(arrayDelimiter);
                        indexProp.getOutput().render(arrayItem, buf);
                        arrayDelimiter = ", ";
                    }
                } else {
                    EventPropertyRendererContext context = rendererOptions.getRendererContext();
                    context.setStringBuilderAndReset(buf);
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object arrayItem = Array.get(value, i);
                        buf.append(arrayDelimiter);
                        context.setPropertyName(indexProp.getName());
                        context.setPropertyValue(arrayItem);
                        context.setIndexedPropertyIndex(i);
                        context.setDefaultRenderer(indexProp.getOutput());
                        rendererOptions.getRenderer().render(context);
                        arrayDelimiter = ", ";
                    }
                }
                buf.append(']');
            }
            delimiter = COMMA_DELIMITER_NEWLINE;
        }
        for (GetterPair mappedProp : mappedProps = meta.getMappedProperties()) {
            Object value3 = mappedProp.getGetter().get(theEvent);
            if (value3 != null && !(value3 instanceof Map)) {
                log.warn("Property '" + mappedProp.getName() + "' expected to return Map and returned " + value3.getClass() + " instead");
                continue;
            }
            JSONRendererImpl.writeDelimitedIndentedProp(buf, delimiter, level, mappedProp.getName());
            if (value3 == null) {
                buf.append("null");
                buf.append(NEWLINE);
            } else {
                Map map = (Map)value3;
                if (map.isEmpty()) {
                    buf.append("{}");
                    buf.append(NEWLINE);
                } else {
                    buf.append('{');
                    buf.append(NEWLINE);
                    String localDelimiter = "";
                    for (Map.Entry entry : map.entrySet()) {
                        if (entry.getKey() == null) continue;
                        buf.append(localDelimiter);
                        JSONRendererImpl.ident(buf, level + 1);
                        buf.append('\"');
                        buf.append((String)entry.getKey());
                        buf.append("\": ");
                        if (entry.getValue() == null) {
                            buf.append("null");
                        } else {
                            OutputValueRenderer outRenderer = OutputValueRendererFactory.getOutputValueRenderer(entry.getValue().getClass(), rendererOptions);
                            if (rendererOptions.getRenderer() == null) {
                                outRenderer.render(entry.getValue(), buf);
                            } else {
                                EventPropertyRendererContext context = rendererOptions.getRendererContext();
                                context.setStringBuilderAndReset(buf);
                                context.setPropertyName(mappedProp.getName());
                                context.setPropertyValue(entry.getValue());
                                context.setMappedPropertyKey((String)entry.getKey());
                                context.setDefaultRenderer(outRenderer);
                                rendererOptions.getRenderer().render(context);
                            }
                        }
                        localDelimiter = COMMA_DELIMITER_NEWLINE;
                    }
                    buf.append(NEWLINE);
                    JSONRendererImpl.ident(buf, level);
                    buf.append('}');
                }
            }
            delimiter = COMMA_DELIMITER_NEWLINE;
        }
        for (NestedGetterPair nestedProp : nestedProps = meta.getNestedProperties()) {
            Object value4 = nestedProp.getGetter().getFragment(theEvent);
            JSONRendererImpl.writeDelimitedIndentedProp(buf, delimiter, level, nestedProp.getName());
            if (value4 == null) {
                buf.append("null");
            } else if (!nestedProp.isArray()) {
                if (!(value4 instanceof EventBean)) {
                    log.warn("Property '" + nestedProp.getName() + "' expected to return EventBean and returned " + value4.getClass() + " instead");
                    buf.append("null");
                    continue;
                }
                EventBean nestedEventBean = (EventBean)value4;
                buf.append('{');
                buf.append(NEWLINE);
                JSONRendererImpl.recursiveRender(nestedEventBean, buf, level + 1, nestedProp.getMetadata(), rendererOptions);
                JSONRendererImpl.ident(buf, level);
                buf.append('}');
            } else {
                if (!(value4 instanceof EventBean[])) {
                    log.warn("Property '" + nestedProp.getName() + "' expected to return EventBean[] and returned " + value4.getClass() + " instead");
                    buf.append("null");
                    continue;
                }
                StringBuilder arrayDelimiterBuf = new StringBuilder();
                arrayDelimiterBuf.append(',');
                arrayDelimiterBuf.append(NEWLINE);
                JSONRendererImpl.ident(arrayDelimiterBuf, level + 1);
                EventBean[] nestedEventArray = (EventBean[])value4;
                String arrayDelimiter = "";
                buf.append('[');
                for (int i = 0; i < nestedEventArray.length; ++i) {
                    EventBean arrayItem = nestedEventArray[i];
                    buf.append(arrayDelimiter);
                    arrayDelimiter = arrayDelimiterBuf.toString();
                    buf.append('{');
                    buf.append(NEWLINE);
                    JSONRendererImpl.recursiveRender(arrayItem, buf, level + 2, nestedProp.getMetadata(), rendererOptions);
                    JSONRendererImpl.ident(buf, level + 1);
                    buf.append('}');
                }
                buf.append(']');
            }
            delimiter = COMMA_DELIMITER_NEWLINE;
        }
        buf.append(NEWLINE);
    }

    private static void writeDelimitedIndentedProp(StringBuilder buf, String delimiter, int level, String name) {
        buf.append(delimiter);
        JSONRendererImpl.ident(buf, level);
        buf.append('\"');
        buf.append(name);
        buf.append("\": ");
    }
}

