/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.thread.InboundUnitSendWrapped;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventType;

public class EventSenderObjectArray
implements EventSender {
    private final EPRuntimeEventSender runtimeEventSender;
    private final EventAdapterService eventAdapterService;
    private final ObjectArrayEventType objectArrayEventType;
    private final ThreadingService threadingService;

    public EventSenderObjectArray(EPRuntimeEventSender runtimeEventSender, ObjectArrayEventType objectArrayEventType, EventAdapterService eventAdapterService, ThreadingService threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.objectArrayEventType = objectArrayEventType;
        this.threadingService = threadingService;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public void sendEvent(Object theEvent) {
        if (!theEvent.getClass().isArray()) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected Object[]");
        }
        Object[] arr = (Object[])theEvent;
        EventBean objectArrayEvent = this.eventAdapterService.adapterForTypedObjectArray(arr, this.objectArrayEventType);
        if (ThreadingOption.isThreadingEnabled && this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(new InboundUnitSendWrapped(objectArrayEvent, this.runtimeEventSender));
        } else {
            this.runtimeEventSender.processWrappedEvent(objectArrayEvent);
        }
    }

    @Override
    public void route(Object theEvent) {
        if (!theEvent.getClass().isArray()) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected Object[]");
        }
        Object[] arr = (Object[])theEvent;
        EventBean objectArrayEvent = this.eventAdapterService.adapterForTypedObjectArray(arr, this.objectArrayEventType);
        this.runtimeEventSender.routeEventBean(objectArrayEvent);
    }
}

