/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeAvro;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.ConfigurationEventTypeObjectArray;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.EventTypeException;
import com.espertech.esper.client.util.EventUnderlyingType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.event.DecoratingEventBean;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventAdapterServiceAnonymousTypeCache;
import com.espertech.esper.event.EventAdapterServiceHelper;
import com.espertech.esper.event.EventBeanAdapterFactory;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.EventBeanSPI;
import com.espertech.esper.event.EventSenderAvro;
import com.espertech.esper.event.EventSenderBean;
import com.espertech.esper.event.EventSenderImpl;
import com.espertech.esper.event.EventSenderMap;
import com.espertech.esper.event.EventSenderObjectArray;
import com.espertech.esper.event.EventSenderURIDesc;
import com.espertech.esper.event.EventSenderXMLDOM;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.WrapperEventBean;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.event.avro.AvroSchemaEventType;
import com.espertech.esper.event.avro.EventAdapterAvroHandler;
import com.espertech.esper.event.bean.BeanEventAdapter;
import com.espertech.esper.event.bean.BeanEventBean;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.BeanEventTypeFactory;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.SchemaXMLEventType;
import com.espertech.esper.event.xml.SimpleXMLEventType;
import com.espertech.esper.event.xml.XMLEventBean;
import com.espertech.esper.plugin.PlugInEventBeanFactory;
import com.espertech.esper.plugin.PlugInEventBeanReflectorContext;
import com.espertech.esper.plugin.PlugInEventRepresentation;
import com.espertech.esper.plugin.PlugInEventTypeHandler;
import com.espertech.esper.plugin.PlugInEventTypeHandlerContext;
import com.espertech.esper.util.TypeWidenerCustomizer;
import com.espertech.esper.util.URIUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventAdapterServiceImpl
implements EventAdapterService {
    private static final Logger log = LoggerFactory.getLogger(EventAdapterServiceImpl.class);
    private final ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean;
    private final Map<String, EventType> nameToTypeMap;
    private final Map<String, PlugInEventTypeHandler> nameToHandlerMap;
    private BeanEventAdapter beanEventAdapter;
    private Map<String, EventType> xmldomRootElementNames;
    private LinkedHashSet<String> javaPackageNames;
    private final Map<URI, PlugInEventRepresentation> plugInRepresentations;
    private final EventTypeIdGenerator eventTypeIdGenerator;
    private final EventAdapterServiceAnonymousTypeCache anonymousTypeCache;
    private final EventAdapterAvroHandler avroHandler;
    private final EngineImportService engineImportService;

    public EventAdapterServiceImpl(EventTypeIdGenerator eventTypeIdGenerator, int anonymousTypeCacheSize, EventAdapterAvroHandler avroHandler, EngineImportService engineImportService) {
        this.eventTypeIdGenerator = eventTypeIdGenerator;
        this.avroHandler = avroHandler;
        this.engineImportService = engineImportService;
        this.nameToTypeMap = new HashMap<String, EventType>();
        this.xmldomRootElementNames = new HashMap<String, EventType>();
        this.javaPackageNames = new LinkedHashSet();
        this.nameToHandlerMap = new HashMap<String, PlugInEventTypeHandler>();
        this.typesPerJavaBean = new ConcurrentHashMap();
        this.beanEventAdapter = new BeanEventAdapter(this.typesPerJavaBean, this, eventTypeIdGenerator);
        this.plugInRepresentations = new HashMap<URI, PlugInEventRepresentation>();
        this.anonymousTypeCache = new EventAdapterServiceAnonymousTypeCache(anonymousTypeCacheSize);
    }

    @Override
    public EngineImportService getEngineImportService() {
        return this.engineImportService;
    }

    @Override
    public Map<String, EventType> getDeclaredEventTypes() {
        return new HashMap<String, EventType>(this.nameToTypeMap);
    }

    @Override
    public void setClassLegacyConfigs(Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs) {
        this.beanEventAdapter.setClassToLegacyConfigs(classToLegacyConfigs);
    }

    @Override
    public ConfigurationEventTypeLegacy getClassLegacyConfigs(String className) {
        return this.beanEventAdapter.getClassToLegacyConfigs(className);
    }

    @Override
    public Set<WriteablePropertyDescriptor> getWriteableProperties(EventType eventType, boolean allowAnyType) {
        return EventAdapterServiceHelper.getWriteableProperties(eventType, allowAnyType);
    }

    @Override
    public EventBeanManufacturer getManufacturer(EventType eventType, WriteablePropertyDescriptor[] properties, EngineImportService engineImportService, boolean allowAnyType) throws EventBeanManufactureException {
        return EventAdapterServiceHelper.getManufacturer(this, eventType, properties, engineImportService, allowAnyType, this.avroHandler);
    }

    @Override
    public EventType[] getAllTypes() {
        Collection<EventType> types = this.nameToTypeMap.values();
        return types.toArray(new EventType[types.size()]);
    }

    @Override
    public synchronized void addTypeByName(String name, EventType eventType) throws EventAdapterException {
        if (this.nameToTypeMap.containsKey(name)) {
            throw new EventAdapterException("Event type by name '" + name + "' already exists");
        }
        this.nameToTypeMap.put(name, eventType);
    }

    @Override
    public void addEventRepresentation(URI eventRepURI, PlugInEventRepresentation pluginEventRep) throws EventAdapterException {
        if (this.plugInRepresentations.containsKey(eventRepURI)) {
            throw new EventAdapterException("Plug-in event representation URI by name " + eventRepURI + " already exists");
        }
        this.plugInRepresentations.put(eventRepURI, pluginEventRep);
    }

    @Override
    public EventType addPlugInEventType(String eventTypeName, URI[] resolutionURIs, Serializable initializer) throws EventAdapterException {
        if (this.nameToTypeMap.containsKey(eventTypeName)) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared");
        }
        PlugInEventRepresentation handlingFactory = null;
        URI handledEventTypeURI = null;
        if (resolutionURIs == null || resolutionURIs.length == 0) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as no resolution URIs for dynamic resolution of event type names through a plug-in event representation have been defined");
        }
        for (URI eventTypeURI : resolutionURIs) {
            HashMap<URI, Object> allFactories = new HashMap<URI, Object>(this.plugInRepresentations);
            Collection<Map.Entry<URI, Object>> factories = URIUtil.filterSort(eventTypeURI, allFactories);
            if (factories.isEmpty()) continue;
            for (Map.Entry<URI, Object> entry : factories) {
                PlugInEventTypeHandlerContext context;
                PlugInEventRepresentation factory = (PlugInEventRepresentation)entry.getValue();
                if (!factory.acceptsType(context = new PlugInEventTypeHandlerContext(eventTypeURI, initializer, eventTypeName, this.eventTypeIdGenerator.getTypeId(eventTypeName)))) continue;
                handlingFactory = factory;
                handledEventTypeURI = eventTypeURI;
                break;
            }
            if (handlingFactory != null) break;
        }
        if (handlingFactory == null) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as none of the registered plug-in event representations accepts any of the resolution URIs '" + Arrays.toString(resolutionURIs) + "' and initializer");
        }
        PlugInEventTypeHandlerContext context = new PlugInEventTypeHandlerContext(handledEventTypeURI, initializer, eventTypeName, this.eventTypeIdGenerator.getTypeId(eventTypeName));
        PlugInEventTypeHandler handler = handlingFactory.getTypeHandler(context);
        if (handler == null) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as no handler was returned");
        }
        EventType eventType = handler.getType();
        this.nameToTypeMap.put(eventTypeName, eventType);
        this.nameToHandlerMap.put(eventTypeName, handler);
        return eventType;
    }

    @Override
    public EventSender getStaticTypeEventSender(EPRuntimeEventSender runtimeEventSender, String eventTypeName, ThreadingService threadingService) throws EventTypeException {
        EventType eventType = this.nameToTypeMap.get(eventTypeName);
        if (eventType == null) {
            throw new EventTypeException("Event type named '" + eventTypeName + "' could not be found");
        }
        if (eventType instanceof BeanEventType) {
            return new EventSenderBean(runtimeEventSender, (BeanEventType)eventType, this, threadingService);
        }
        if (eventType instanceof MapEventType) {
            return new EventSenderMap(runtimeEventSender, (MapEventType)eventType, this, threadingService);
        }
        if (eventType instanceof ObjectArrayEventType) {
            return new EventSenderObjectArray(runtimeEventSender, (ObjectArrayEventType)eventType, this, threadingService);
        }
        if (eventType instanceof BaseXMLEventType) {
            return new EventSenderXMLDOM(runtimeEventSender, (BaseXMLEventType)eventType, this, threadingService);
        }
        if (eventType instanceof AvroSchemaEventType) {
            return new EventSenderAvro(runtimeEventSender, eventType, this, threadingService);
        }
        PlugInEventTypeHandler handlers = this.nameToHandlerMap.get(eventTypeName);
        if (handlers != null) {
            return handlers.getSender(runtimeEventSender);
        }
        throw new EventTypeException("An event sender for event type named '" + eventTypeName + "' could not be created as the type is internal");
    }

    @Override
    public void updateMapEventType(String mapeventTypeName, Map<String, Object> typeMap) throws EventAdapterException {
        EventType type = this.nameToTypeMap.get(mapeventTypeName);
        if (type == null) {
            throw new EventAdapterException("Event type named '" + mapeventTypeName + "' has not been declared");
        }
        if (!(type instanceof MapEventType)) {
            throw new EventAdapterException("Event type by name '" + mapeventTypeName + "' is not a Map event type");
        }
        MapEventType mapEventType = (MapEventType)type;
        mapEventType.addAdditionalProperties(typeMap, this);
    }

    @Override
    public void updateObjectArrayEventType(String objectArrayEventTypeName, Map<String, Object> typeMap) throws EventAdapterException {
        EventType type = this.nameToTypeMap.get(objectArrayEventTypeName);
        if (type == null) {
            throw new EventAdapterException("Event type named '" + objectArrayEventTypeName + "' has not been declared");
        }
        if (!(type instanceof ObjectArrayEventType)) {
            throw new EventAdapterException("Event type by name '" + objectArrayEventTypeName + "' is not an Object-array event type");
        }
        ObjectArrayEventType objectArrayEventType = (ObjectArrayEventType)type;
        objectArrayEventType.addAdditionalProperties(typeMap, this);
    }

    @Override
    public EventSender getDynamicTypeEventSender(EPRuntimeEventSender epRuntime, URI[] uri, ThreadingService threadingService) throws EventTypeException {
        ArrayList<EventSenderURIDesc> handlingFactories = new ArrayList<EventSenderURIDesc>();
        for (URI resolutionURI : uri) {
            HashMap<URI, Object> allFactories = new HashMap<URI, Object>(this.plugInRepresentations);
            Collection<Map.Entry<URI, Object>> factories = URIUtil.filterSort(resolutionURI, allFactories);
            if (factories.isEmpty()) continue;
            for (Map.Entry<URI, Object> entry : factories) {
                PlugInEventBeanReflectorContext context;
                PlugInEventRepresentation factory = (PlugInEventRepresentation)entry.getValue();
                if (!factory.acceptsEventBeanResolution(context = new PlugInEventBeanReflectorContext(resolutionURI))) continue;
                PlugInEventBeanFactory beanFactory = factory.getEventBeanFactory(context);
                if (beanFactory == null) {
                    log.warn("Plug-in event representation returned a null bean factory, ignoring entry");
                    continue;
                }
                EventSenderURIDesc desc = new EventSenderURIDesc(beanFactory, resolutionURI, entry.getKey());
                handlingFactories.add(desc);
            }
        }
        if (handlingFactories.isEmpty()) {
            throw new EventTypeException("Event sender for resolution URIs '" + Arrays.toString(uri) + "' did not return at least one event representation's event factory");
        }
        return new EventSenderImpl(handlingFactories, epRuntime, threadingService);
    }

    @Override
    public BeanEventTypeFactory getBeanEventTypeFactory() {
        return this.beanEventAdapter;
    }

    @Override
    public void setDefaultPropertyResolutionStyle(Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.beanEventAdapter.setDefaultPropertyResolutionStyle(defaultPropertyResolutionStyle);
    }

    @Override
    public void setDefaultAccessorStyle(ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle) {
        this.beanEventAdapter.setDefaultAccessorStyle(defaultAccessorStyle);
    }

    @Override
    public EventType getExistsTypeByName(String eventTypeName) {
        if (eventTypeName == null) {
            throw new IllegalStateException("Null event type name parameter");
        }
        return this.nameToTypeMap.get(eventTypeName);
    }

    @Override
    public synchronized EventType addBeanType(String eventTypeName, Class clazz, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured) throws EventAdapterException {
        EventType existingType;
        if (log.isDebugEnabled()) {
            log.debug(".addBeanType Adding " + eventTypeName + " for type " + clazz.getName());
        }
        if ((existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
            if (existingType.getUnderlyingType().equals(clazz)) {
                return existingType;
            }
            throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing underlying type information:" + existingType.getUnderlyingType().getName() + " versus " + clazz.getName());
        }
        BeanEventType eventType = this.beanEventAdapter.createBeanType(eventTypeName, clazz, isPreconfiguredStatic, isPreconfigured, isConfigured);
        this.nameToTypeMap.put(eventTypeName, eventType);
        return eventType;
    }

    @Override
    public synchronized EventType addBeanTypeByName(String eventTypeName, Class clazz, boolean isNamedWindow) throws EventAdapterException {
        EventType existingType;
        if (log.isDebugEnabled()) {
            log.debug(".addBeanTypeNamedWindow Adding " + eventTypeName + " for type " + clazz.getName());
        }
        if ((existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
            if (existingType instanceof BeanEventType && existingType.getUnderlyingType() == clazz && existingType.getName().equals(eventTypeName)) {
                EventTypeMetadata.TypeClass typeClass = ((BeanEventType)existingType).getMetadata().getTypeClass();
                if (isNamedWindow ? typeClass == EventTypeMetadata.TypeClass.NAMED_WINDOW : typeClass == EventTypeMetadata.TypeClass.STREAM) {
                    return existingType;
                }
            }
            throw new EventAdapterException("An event type named '" + eventTypeName + "' has already been declared");
        }
        EventTypeMetadata.TypeClass typeClass = isNamedWindow ? EventTypeMetadata.TypeClass.NAMED_WINDOW : EventTypeMetadata.TypeClass.STREAM;
        BeanEventType beanEventType = new BeanEventType(EventTypeMetadata.createBeanType(eventTypeName, clazz, false, false, false, typeClass), this.eventTypeIdGenerator.getTypeId(eventTypeName), clazz, this, this.beanEventAdapter.getClassToLegacyConfigs(clazz.getName()));
        this.nameToTypeMap.put(eventTypeName, beanEventType);
        return beanEventType;
    }

    @Override
    public EventBean adapterForBean(Object theEvent) {
        EventType eventType = this.typesPerJavaBean.get(theEvent.getClass());
        if (eventType == null) {
            eventType = this.beanEventAdapter.createBeanType(theEvent.getClass().getName(), theEvent.getClass(), false, false, false);
        }
        return new BeanEventBean(theEvent, eventType);
    }

    @Override
    public synchronized EventType addBeanType(String eventTypeName, String fullyQualClassName, boolean considerAutoName, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured) throws EventAdapterException {
        Class clazz;
        block11: {
            EventType existingType;
            if (log.isDebugEnabled()) {
                log.debug(".addBeanType Adding " + eventTypeName + " for type " + fullyQualClassName);
            }
            if ((existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
                if (existingType.getUnderlyingType().getName().equals(fullyQualClassName) || existingType.getUnderlyingType().getSimpleName().equals(fullyQualClassName)) {
                    if (log.isDebugEnabled()) {
                        log.debug(".addBeanType Returning existing type for " + eventTypeName);
                    }
                    return existingType;
                }
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing underlying type information: Class " + existingType.getUnderlyingType().getName() + " versus " + fullyQualClassName);
            }
            clazz = null;
            try {
                clazz = this.engineImportService.getClassForNameProvider().classForName(fullyQualClassName);
            }
            catch (ClassNotFoundException ex) {
                if (!considerAutoName) {
                    throw new EventAdapterException("Event type or class named '" + fullyQualClassName + "' was not found", ex);
                }
                for (String javaPackageName : this.javaPackageNames) {
                    String generatedClassName = javaPackageName + "." + fullyQualClassName;
                    try {
                        Class resolvedClass = this.engineImportService.getClassForNameProvider().classForName(generatedClassName);
                        if (clazz != null) {
                            throw new EventAdapterException("Failed to resolve name '" + eventTypeName + "', the class was ambigously found both in package '" + clazz.getPackage().getName() + "' and in package '" + resolvedClass.getPackage().getName() + "'", ex);
                        }
                        clazz = resolvedClass;
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                if (clazz != null) break block11;
                throw new EventAdapterException("Event type or class named '" + fullyQualClassName + "' was not found", ex);
            }
        }
        BeanEventType eventType = this.beanEventAdapter.createBeanType(eventTypeName, clazz, isPreconfiguredStatic, isPreconfigured, isConfigured);
        this.nameToTypeMap.put(eventTypeName, eventType);
        return eventType;
    }

    @Override
    public synchronized EventType addNestableMapType(String eventTypeName, Map<String, Object> propertyTypesMayHavePrimitive, ConfigurationEventTypeMap optionalConfig, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured, boolean namedWindow, boolean insertInto) throws EventAdapterException {
        Pair<EventType[], Set<EventType>> mapSuperTypes = EventTypeUtility.getSuperTypesDepthFirst(optionalConfig, EventUnderlyingType.MAP, this.nameToTypeMap);
        EventTypeMetadata metadata = EventTypeMetadata.createNonPojoApplicationType(EventTypeMetadata.ApplicationType.MAP, eventTypeName, isPreconfiguredStatic, isPreconfigured, isConfigured, namedWindow, insertInto);
        int typeId = this.eventTypeIdGenerator.getTypeId(eventTypeName);
        Map<String, Object> propertyTypes = EventTypeUtility.getPropertyTypesNonPrimitive(propertyTypesMayHavePrimitive);
        MapEventType newEventType = new MapEventType(metadata, eventTypeName, typeId, this, propertyTypes, mapSuperTypes.getFirst(), mapSuperTypes.getSecond(), optionalConfig);
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            if (!newEventType.equalsCompareType(existingType)) {
                String message = newEventType.getEqualsMessage(existingType);
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message);
            }
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    @Override
    public synchronized EventType addNestableObjectArrayType(String eventTypeName, Map<String, Object> propertyTypesMayHavePrimitive, ConfigurationEventTypeObjectArray optionalConfig, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured, boolean namedWindow, boolean insertInto, boolean table, String tableName) throws EventAdapterException {
        if (optionalConfig != null && optionalConfig.getSuperTypes().size() > 1) {
            throw new EventAdapterException("Object-array event types only allow a single supertype");
        }
        Pair<EventType[], Set<EventType>> mapSuperTypes = EventTypeUtility.getSuperTypesDepthFirst(optionalConfig, EventUnderlyingType.OBJECTARRAY, this.nameToTypeMap);
        EventTypeMetadata metadata = table ? EventTypeMetadata.createTable(tableName) : EventTypeMetadata.createNonPojoApplicationType(EventTypeMetadata.ApplicationType.OBJECTARR, eventTypeName, isPreconfiguredStatic, isPreconfigured, isConfigured, namedWindow, insertInto);
        int typeId = this.eventTypeIdGenerator.getTypeId(eventTypeName);
        Map<String, Object> propertyTypes = EventTypeUtility.getPropertyTypesNonPrimitive(propertyTypesMayHavePrimitive);
        ObjectArrayEventType newEventType = new ObjectArrayEventType(metadata, eventTypeName, typeId, this, propertyTypes, optionalConfig, mapSuperTypes.getFirst(), mapSuperTypes.getSecond());
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            if (!newEventType.equalsCompareType(existingType)) {
                String message = newEventType.getEqualsMessage(existingType);
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message);
            }
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    @Override
    public EventBean adapterForMap(Map<String, Object> theEvent, String eventTypeName) throws EPException {
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (!(existingType instanceof MapEventType)) {
            throw new EPException(EventAdapterServiceHelper.getMessageExpecting(eventTypeName, existingType, "Map"));
        }
        return this.adapterForTypedMap(theEvent, existingType);
    }

    @Override
    public EventBean adapterForObjectArray(Object[] theEvent, String eventTypeName) throws EPException {
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (!(existingType instanceof ObjectArrayEventType)) {
            throw new EPException(EventAdapterServiceHelper.getMessageExpecting(eventTypeName, existingType, "Object-array"));
        }
        return this.adapterForTypedObjectArray(theEvent, existingType);
    }

    @Override
    public EventBean adapterForDOM(Node node) {
        EventType eventType;
        Node namedNode;
        if (node instanceof Document) {
            namedNode = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            namedNode = node;
        } else {
            throw new EPException("Unexpected DOM node of type '" + node.getClass() + "' encountered, please supply a Document or Element node");
        }
        String rootElementName = namedNode.getLocalName();
        if (rootElementName == null) {
            rootElementName = namedNode.getNodeName();
        }
        if ((eventType = this.xmldomRootElementNames.get(rootElementName)) == null) {
            throw new EventAdapterException("DOM event root element name '" + rootElementName + "' has not been configured");
        }
        return new XMLEventBean(namedNode, eventType);
    }

    @Override
    public EventBean adapterForTypedDOM(Node node, EventType eventType) {
        return new XMLEventBean(node, eventType);
    }

    @Override
    public synchronized EventType addXMLDOMType(String eventTypeName, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM, SchemaModel optionalSchemaModel, boolean isPreconfiguredStatic) {
        return this.addXMLDOMType(eventTypeName, configurationEventTypeXMLDOM, optionalSchemaModel, isPreconfiguredStatic, false);
    }

    @Override
    public EventType replaceXMLEventType(String xmlEventTypeName, ConfigurationEventTypeXMLDOM config, SchemaModel schemaModel) {
        return this.addXMLDOMType(xmlEventTypeName, config, schemaModel, false, true);
    }

    private synchronized EventType addXMLDOMType(String eventTypeName, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM, SchemaModel optionalSchemaModel, boolean isPreconfiguredStatic, boolean allowOverrideExisting) {
        BaseXMLEventType type;
        EventType existingType;
        if (configurationEventTypeXMLDOM.getRootElementName() == null) {
            throw new EventAdapterException("Required root element name has not been supplied");
        }
        if (!allowOverrideExisting && (existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
            String message = "Event type named '" + eventTypeName + "' has already been declared with differing column name or type information";
            if (!(existingType instanceof BaseXMLEventType)) {
                throw new EventAdapterException(message);
            }
            ConfigurationEventTypeXMLDOM config = ((BaseXMLEventType)existingType).getConfigurationEventTypeXMLDOM();
            if (!config.equals(configurationEventTypeXMLDOM)) {
                throw new EventAdapterException(message);
            }
            return existingType;
        }
        EventTypeMetadata metadata = EventTypeMetadata.createXMLType(eventTypeName, isPreconfiguredStatic, configurationEventTypeXMLDOM.getSchemaResource() == null && configurationEventTypeXMLDOM.getSchemaText() == null);
        if (configurationEventTypeXMLDOM.getSchemaResource() == null && configurationEventTypeXMLDOM.getSchemaText() == null) {
            type = new SimpleXMLEventType(metadata, this.eventTypeIdGenerator.getTypeId(eventTypeName), configurationEventTypeXMLDOM, this);
        } else {
            if (optionalSchemaModel == null) {
                throw new EPException("Schema model has not been provided");
            }
            type = new SchemaXMLEventType(metadata, this.eventTypeIdGenerator.getTypeId(eventTypeName), configurationEventTypeXMLDOM, optionalSchemaModel, this);
        }
        this.nameToTypeMap.put(eventTypeName, type);
        this.xmldomRootElementNames.put(configurationEventTypeXMLDOM.getRootElementName(), type);
        return type;
    }

    @Override
    public final EventBean adapterForType(Object theEvent, EventType eventType) {
        return EventAdapterServiceHelper.adapterForType(theEvent, eventType, this);
    }

    @Override
    public final EventBean adapterForTypedMap(Map<String, Object> properties, EventType eventType) {
        return new MapEventBean(properties, eventType);
    }

    @Override
    public final EventBean adapterForTypedObjectArray(Object[] properties, EventType eventType) {
        return new ObjectArrayEventBean(properties, eventType);
    }

    @Override
    public synchronized EventType addWrapperType(String eventTypeName, EventType underlyingEventType, Map<String, Object> propertyTypesMayPrimitive, boolean isNamedWindow, boolean isInsertInto) throws EventAdapterException {
        if (underlyingEventType instanceof WrapperEventType) {
            WrapperEventType underlyingWrapperType = (WrapperEventType)underlyingEventType;
            underlyingEventType = underlyingWrapperType.getUnderlyingEventType();
            HashMap<String, Object> propertiesSuperset = new HashMap<String, Object>();
            propertiesSuperset.putAll(underlyingWrapperType.getUnderlyingMapType().getTypes());
            propertiesSuperset.putAll(propertyTypesMayPrimitive);
            propertyTypesMayPrimitive = propertiesSuperset;
        }
        boolean isPropertyAgnostic = false;
        if (underlyingEventType instanceof EventTypeSPI) {
            isPropertyAgnostic = ((EventTypeSPI)underlyingEventType).getMetadata().isPropertyAgnostic();
        }
        EventTypeMetadata metadata = EventTypeMetadata.createWrapper(eventTypeName, isNamedWindow, isInsertInto, isPropertyAgnostic);
        int typeId = this.eventTypeIdGenerator.getTypeId(eventTypeName);
        Map<String, Object> propertyTypes = EventTypeUtility.getPropertyTypesNonPrimitive(propertyTypesMayPrimitive);
        WrapperEventType newEventType = new WrapperEventType(metadata, eventTypeName, typeId, underlyingEventType, propertyTypes, this);
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            if (!newEventType.equalsCompareType(existingType)) {
                String message = EventAdapterServiceImpl.isCompatibleWrapper(existingType, underlyingEventType, propertyTypes);
                if (message == null) {
                    return existingType;
                }
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message);
            }
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    public static String isCompatibleWrapper(EventType existingType, EventType underlyingType, Map<String, Object> propertyTypes) {
        if (!(existingType instanceof WrapperEventType)) {
            return "Type '" + existingType.getName() + "' is not compatible";
        }
        WrapperEventType existingWrapper = (WrapperEventType)existingType;
        String message = MapEventType.isDeepEqualsProperties(existingType.getName(), existingWrapper.getUnderlyingMapType().getTypes(), propertyTypes);
        if (message != null) {
            return message;
        }
        EventType existingUnderlyingType = existingWrapper.getUnderlyingEventType();
        if (underlyingType.getSuperTypes() == null) {
            return "Type '" + existingType.getName() + "' is not compatible";
        }
        Iterator<EventType> it = underlyingType.getDeepSuperTypes();
        while (it.hasNext()) {
            EventType superUnderlying = it.next();
            if (superUnderlying != existingUnderlyingType) continue;
            return null;
        }
        return "Type '" + existingType.getName() + "' is not compatible";
    }

    @Override
    public final EventType createAnonymousMapType(String typeName, Map<String, Object> propertyTypesMayHavePrimitive, boolean isTransient) throws EventAdapterException {
        String assignedTypeName = "anonymous_" + typeName;
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(assignedTypeName, EventTypeMetadata.ApplicationType.MAP);
        Map<String, Object> propertyTypes = EventTypeUtility.getPropertyTypesNonPrimitive(propertyTypesMayHavePrimitive);
        MapEventType mapEventType = new MapEventType(metadata, assignedTypeName, this.eventTypeIdGenerator.getTypeId(assignedTypeName), this, propertyTypes, null, null, null);
        return this.anonymousTypeCache.addReturnExistingAnonymousType(mapEventType);
    }

    @Override
    public final EventType createAnonymousObjectArrayType(String typeName, Map<String, Object> propertyTypesMayHavePrimitive) throws EventAdapterException {
        String assignedTypeName = "anonymous_" + typeName;
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(assignedTypeName, EventTypeMetadata.ApplicationType.OBJECTARR);
        Map<String, Object> propertyTypes = EventTypeUtility.getPropertyTypesNonPrimitive(propertyTypesMayHavePrimitive);
        ObjectArrayEventType oaEventType = new ObjectArrayEventType(metadata, assignedTypeName, this.eventTypeIdGenerator.getTypeId(assignedTypeName), this, propertyTypes, null, null, null);
        return this.anonymousTypeCache.addReturnExistingAnonymousType(oaEventType);
    }

    @Override
    public final EventType createAnonymousAvroType(String typeName, Map<String, Object> properties, Annotation[] annotations, String statementName, String engineURI) throws EventAdapterException {
        String assignedTypeName = "anonymous_" + typeName;
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(assignedTypeName, EventTypeMetadata.ApplicationType.AVRO);
        int typeId = this.eventTypeIdGenerator.getTypeId(assignedTypeName);
        AvroSchemaEventType newEventType = this.avroHandler.newEventTypeFromNormalized(metadata, assignedTypeName, typeId, this, properties, annotations, null, null, null, statementName, engineURI);
        return this.anonymousTypeCache.addReturnExistingAnonymousType(newEventType);
    }

    @Override
    public EventType createSemiAnonymousMapType(String typeName, Map<String, Pair<EventType, String>> taggedEventTypes, Map<String, Pair<EventType, String>> arrayEventTypes, boolean isUsedByChildViews) {
        LinkedHashMap<String, Object> mapProperties = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Pair<EventType, String>> entry : taggedEventTypes.entrySet()) {
            mapProperties.put(entry.getKey(), entry.getValue().getFirst());
        }
        for (Map.Entry<String, Pair<EventType, String>> entry : arrayEventTypes.entrySet()) {
            mapProperties.put(entry.getKey(), new EventType[]{entry.getValue().getFirst()});
        }
        return this.createAnonymousMapType(typeName, mapProperties, true);
    }

    @Override
    public final EventType createAnonymousWrapperType(String typeName, EventType underlyingEventType, Map<String, Object> propertyTypesMayPrimitive) throws EventAdapterException {
        String assignedTypeName = "anonymous_" + typeName;
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(assignedTypeName, EventTypeMetadata.ApplicationType.WRAPPER);
        if (underlyingEventType instanceof WrapperEventType) {
            WrapperEventType underlyingWrapperType = (WrapperEventType)underlyingEventType;
            underlyingEventType = underlyingWrapperType.getUnderlyingEventType();
            HashMap<String, Object> propertiesSuperset = new HashMap<String, Object>();
            propertiesSuperset.putAll(underlyingWrapperType.getUnderlyingMapType().getTypes());
            propertiesSuperset.putAll(propertyTypesMayPrimitive);
            propertyTypesMayPrimitive = propertiesSuperset;
        }
        Map<String, Object> propertyTypes = EventTypeUtility.getPropertyTypesNonPrimitive(propertyTypesMayPrimitive);
        WrapperEventType wrapperEventType = new WrapperEventType(metadata, assignedTypeName, this.eventTypeIdGenerator.getTypeId(assignedTypeName), underlyingEventType, propertyTypes, this);
        return this.anonymousTypeCache.addReturnExistingAnonymousType(wrapperEventType);
    }

    @Override
    public final EventBean adapterForTypedWrapper(EventBean theEvent, Map<String, Object> properties, EventType eventType) {
        if (theEvent instanceof DecoratingEventBean) {
            DecoratingEventBean wrapper = (DecoratingEventBean)((Object)theEvent);
            properties.putAll(wrapper.getDecoratingProperties());
            return new WrapperEventBean(wrapper.getUnderlyingEvent(), properties, eventType);
        }
        return new WrapperEventBean(theEvent, properties, eventType);
    }

    @Override
    public final EventBean adapterForTypedBean(Object bean, EventType eventType) {
        return new BeanEventBean(bean, eventType);
    }

    @Override
    public void addAutoNamePackage(String javaPackageName) {
        this.javaPackageNames.add(javaPackageName);
    }

    @Override
    public EventType createAnonymousBeanType(String eventTypeName, Class clazz) {
        BeanEventType beanEventType = new BeanEventType(EventTypeMetadata.createBeanType(eventTypeName, clazz, false, false, false, EventTypeMetadata.TypeClass.ANONYMOUS), -1, clazz, this, this.beanEventAdapter.getClassToLegacyConfigs(clazz.getName()));
        return this.anonymousTypeCache.addReturnExistingAnonymousType(beanEventType);
    }

    @Override
    public EventBean[] typeCast(List<EventBean> events, EventType targetType) {
        return EventAdapterServiceHelper.typeCast(events, targetType, this);
    }

    @Override
    public boolean removeType(String name) {
        EventType eventType = this.nameToTypeMap.remove(name);
        if (eventType == null) {
            return false;
        }
        if (eventType instanceof BaseXMLEventType) {
            BaseXMLEventType baseXML = (BaseXMLEventType)eventType;
            this.xmldomRootElementNames.remove(baseXML.getRootElementName());
        }
        this.nameToHandlerMap.remove(name);
        return true;
    }

    @Override
    public EventBeanSPI getShellForType(EventType eventType) {
        return EventAdapterServiceHelper.getShellForType(eventType);
    }

    @Override
    public EventBeanAdapterFactory getAdapterFactoryForType(EventType eventType) {
        return EventAdapterServiceHelper.getAdapterFactoryForType(eventType);
    }

    @Override
    public EventType addAvroType(String eventTypeName, ConfigurationEventTypeAvro avro, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured, boolean isNamedWindow, boolean isInsertInto) throws EventAdapterException {
        EventTypeMetadata metadata = EventTypeMetadata.createNonPojoApplicationType(EventTypeMetadata.ApplicationType.AVRO, eventTypeName, isPreconfiguredStatic, isPreconfigured, isConfigured, isNamedWindow, isInsertInto);
        int typeId = this.eventTypeIdGenerator.getTypeId(eventTypeName);
        Pair<EventType[], Set<EventType>> avroSuperTypes = EventTypeUtility.getSuperTypesDepthFirst(avro, EventUnderlyingType.AVRO, this.nameToTypeMap);
        AvroSchemaEventType newEventType = this.avroHandler.newEventTypeFromSchema(metadata, eventTypeName, typeId, this, avro, avroSuperTypes.getFirst(), avroSuperTypes.getSecond());
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            this.avroHandler.validateExistingType(existingType, newEventType);
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    @Override
    public EventType addAvroType(String eventTypeName, Map<String, Object> types, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured, boolean isNamedWindow, boolean isInsertInto, Annotation[] annotations, ConfigurationEventTypeAvro config, String statementName, String engineURI) throws EventAdapterException {
        EventTypeMetadata metadata = EventTypeMetadata.createNonPojoApplicationType(EventTypeMetadata.ApplicationType.AVRO, eventTypeName, isPreconfiguredStatic, isPreconfigured, isConfigured, isNamedWindow, isInsertInto);
        int typeId = this.eventTypeIdGenerator.getTypeId(eventTypeName);
        Pair<EventType[], Set<EventType>> avroSuperTypes = EventTypeUtility.getSuperTypesDepthFirst(config, EventUnderlyingType.AVRO, this.nameToTypeMap);
        AvroSchemaEventType newEventType = this.avroHandler.newEventTypeFromNormalized(metadata, eventTypeName, typeId, this, types, annotations, config, avroSuperTypes.getFirst(), avroSuperTypes.getSecond(), statementName, engineURI);
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            this.avroHandler.validateExistingType(existingType, newEventType);
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    @Override
    public EventBean adapterForAvro(Object avroGenericDataDotRecord, String eventTypeName) {
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (!(existingType instanceof AvroSchemaEventType)) {
            throw new EPException(EventAdapterServiceHelper.getMessageExpecting(eventTypeName, existingType, "Avro"));
        }
        return this.avroHandler.adapterForTypeAvro(avroGenericDataDotRecord, existingType);
    }

    @Override
    public EventBean adapterForTypedAvro(Object avroGenericDataDotRecord, EventType eventType) {
        return this.avroHandler.adapterForTypeAvro(avroGenericDataDotRecord, eventType);
    }

    @Override
    public EventAdapterAvroHandler getEventAdapterAvroHandler() {
        return this.avroHandler;
    }

    @Override
    public TypeWidenerCustomizer getTypeWidenerCustomizer(EventType resultEventType) {
        return resultEventType instanceof AvroSchemaEventType ? this.avroHandler.getTypeWidenerCustomizer(resultEventType) : null;
    }
}

