/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventPropertyGetterMapped;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterIndexedSPI;
import com.espertech.esper.event.EventPropertyGetterMappedSPI;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.ExplicitPropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfigurableEventType
implements EventTypeSPI {
    private static final Logger log = LoggerFactory.getLogger(BaseConfigurableEventType.class);
    private EventAdapterService eventAdapterService;
    private final int eventTypeId;
    private final EventTypeMetadata metadata;
    private Class underlyngType;
    private EventPropertyDescriptor[] propertyDescriptors;
    private String[] propertyNames;
    private Map<String, Pair<ExplicitPropertyDescriptor, FragmentEventType>> propertyFragmentTypes;
    private Map<String, EventPropertyGetter> propertyGetterCodegeneratedCache;
    protected Map<String, EventPropertyGetterSPI> propertyGetters;
    protected Map<String, EventPropertyDescriptor> propertyDescriptorMap;

    protected BaseConfigurableEventType(EventAdapterService eventAdapterService, EventTypeMetadata metadata, int eventTypeId, Class underlyngType) {
        this.eventTypeId = eventTypeId;
        this.eventAdapterService = eventAdapterService;
        this.metadata = metadata;
        this.underlyngType = underlyngType;
    }

    @Override
    public int getEventTypeId() {
        return this.eventTypeId;
    }

    protected abstract EventPropertyGetterSPI doResolvePropertyGetter(String var1);

    protected abstract Class doResolvePropertyType(String var1);

    protected abstract FragmentEventType doResolveFragmentType(String var1);

    @Override
    public String getName() {
        return this.metadata.getPrimaryName();
    }

    public EventAdapterService getEventAdapterService() {
        return this.eventAdapterService;
    }

    protected void initialize(List<ExplicitPropertyDescriptor> explicitProperties) {
        this.propertyGetters = new HashMap<String, EventPropertyGetterSPI>();
        this.propertyDescriptors = new EventPropertyDescriptor[explicitProperties.size()];
        this.propertyNames = new String[explicitProperties.size()];
        this.propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        this.propertyFragmentTypes = new HashMap<String, Pair<ExplicitPropertyDescriptor, FragmentEventType>>();
        int count = 0;
        for (ExplicitPropertyDescriptor explicit : explicitProperties) {
            EventPropertyDescriptor desc;
            this.propertyNames[count] = explicit.getDescriptor().getPropertyName();
            this.propertyGetters.put(explicit.getDescriptor().getPropertyName(), explicit.getGetter());
            this.propertyDescriptors[count] = desc = explicit.getDescriptor();
            this.propertyDescriptorMap.put(desc.getPropertyName(), desc);
            if (explicit.getOptionalFragmentTypeName() != null) {
                this.propertyFragmentTypes.put(explicit.getDescriptor().getPropertyName(), new Pair<ExplicitPropertyDescriptor, Object>(explicit, null));
            }
            if (!desc.isFragment()) {
                this.propertyFragmentTypes.put(explicit.getDescriptor().getPropertyName(), null);
            }
            ++count;
        }
    }

    @Override
    public Class getPropertyType(String propertyExpression) {
        EventPropertyDescriptor desc = this.propertyDescriptorMap.get(propertyExpression);
        if (desc != null) {
            return desc.getPropertyType();
        }
        return this.doResolvePropertyType(propertyExpression);
    }

    @Override
    public Class getUnderlyingType() {
        return this.underlyngType;
    }

    @Override
    public EventPropertyGetterSPI getGetterSPI(String propertyExpression) {
        EventPropertyGetterSPI getter = this.propertyGetters.get(propertyExpression);
        if (getter != null) {
            return getter;
        }
        return this.doResolvePropertyGetter(propertyExpression);
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        EventPropertyGetter getter;
        if (!this.eventAdapterService.getEngineImportService().isCodegenEventPropertyGetters()) {
            return this.getGetterSPI(propertyName);
        }
        if (this.propertyGetterCodegeneratedCache == null) {
            this.propertyGetterCodegeneratedCache = new HashMap<String, EventPropertyGetter>();
        }
        if ((getter = this.propertyGetterCodegeneratedCache.get(propertyName)) != null) {
            return getter;
        }
        EventPropertyGetterSPI getterSPI = this.getGetterSPI(propertyName);
        if (getterSPI == null) {
            return null;
        }
        EventPropertyGetter getterCode = this.eventAdapterService.getEngineImportService().codegenGetter(getterSPI, this.metadata.getPublicName(), propertyName);
        this.propertyGetterCodegeneratedCache.put(propertyName, getterCode);
        return getterCode;
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedProperty) {
        EventPropertyGetterMappedSPI getter = this.getGetterMappedSPI(mappedProperty);
        if (getter == null) {
            return null;
        }
        if (!this.eventAdapterService.getEngineImportService().isCodegenEventPropertyGetters()) {
            return getter;
        }
        return this.eventAdapterService.getEngineImportService().codegenGetter(getter, this.metadata.getPublicName(), mappedProperty);
    }

    @Override
    public EventPropertyGetterMappedSPI getGetterMappedSPI(String mappedProperty) {
        EventPropertyGetter getter = this.getGetter(mappedProperty);
        if (getter instanceof EventPropertyGetterMappedSPI) {
            return (EventPropertyGetterMappedSPI)((Object)getter);
        }
        return null;
    }

    @Override
    public EventPropertyGetterIndexedSPI getGetterIndexedSPI(String propertyName) {
        return null;
    }

    @Override
    public EventPropertyGetterIndexedSPI getGetterIndexed(String indexedProperty) {
        return null;
    }

    @Override
    public synchronized FragmentEventType getFragmentType(String property) {
        Pair<ExplicitPropertyDescriptor, FragmentEventType> pair = this.propertyFragmentTypes.get(property);
        if (pair == null) {
            if (this.propertyFragmentTypes.containsKey(property)) {
                return null;
            }
            return this.doResolveFragmentType(property);
        }
        if (pair.getSecond() != null) {
            return pair.getSecond();
        }
        EventType existingType = this.eventAdapterService.getExistsTypeByName(pair.getFirst().getOptionalFragmentTypeName());
        if (!(existingType instanceof BaseConfigurableEventType)) {
            log.warn("Type configured for fragment event property '" + property + "' by name '" + pair.getFirst() + "' could not be found");
            return null;
        }
        FragmentEventType fragmentType = new FragmentEventType(existingType, pair.getFirst().isFragmentArray(), false);
        pair.setSecond(fragmentType);
        return fragmentType;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public boolean isProperty(String property) {
        return this.getGetter(property) != null;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName);
    }
}

