/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledCrontabState;
import com.espertech.esper.epl.view.OutputConditionPolledState;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionPolledCrontab
implements OutputConditionPolled {
    private final AgentInstanceContext agentInstanceContext;
    private final OutputConditionPolledCrontabState state;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionPolledCrontab.class);

    public OutputConditionPolledCrontab(AgentInstanceContext agentInstanceContext, OutputConditionPolledCrontabState state) {
        this.agentInstanceContext = agentInstanceContext;
        this.state = state;
    }

    @Override
    public OutputConditionPolledState getState() {
        return this.state;
    }

    @Override
    public final boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount);
        }
        boolean output = false;
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        EngineImportService engineImportService = this.agentInstanceContext.getEngineImportService();
        if (this.state.getCurrentReferencePoint() == null) {
            this.state.setCurrentReferencePoint(currentTime);
            this.state.setNextScheduledTime(ScheduleComputeHelper.computeNextOccurance(this.state.getScheduleSpec(), currentTime, engineImportService.getTimeZone(), engineImportService.getTimeAbacus()));
            output = true;
        }
        if (this.state.getNextScheduledTime() <= currentTime) {
            this.state.setNextScheduledTime(ScheduleComputeHelper.computeNextOccurance(this.state.getScheduleSpec(), currentTime, engineImportService.getTimeZone(), engineImportService.getTimeAbacus()));
            output = true;
        }
        return output;
    }
}

