/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.updatehelper;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.codegen.ExprNodeCompiler;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateHelper;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateItem;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.util.StringValue;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerCustomizer;
import com.espertech.esper.util.TypeWidenerException;
import com.espertech.esper.util.TypeWidenerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventBeanUpdateHelperFactory {
    public static EventBeanUpdateHelper make(String updatedWindowOrTableName, EventTypeSPI eventTypeSPI, List<OnTriggerSetAssignment> assignments, String updatedAlias, EventType optionalTriggeringEventType, boolean isCopyOnWrite, String statementName, String engineURI, EventAdapterService eventAdapterService, boolean isFireAndForget) throws ExprValidationException {
        EventBeanCopyMethod copyMethod;
        ArrayList<EventBeanUpdateItem> updateItems = new ArrayList<EventBeanUpdateItem>();
        ArrayList<String> properties = new ArrayList<String>();
        TypeWidenerCustomizer typeWidenerCustomizer = eventAdapterService.getTypeWidenerCustomizer(eventTypeSPI);
        for (int i = 0; i < assignments.size(); ++i) {
            EventBeanUpdateItem updateItem;
            OnTriggerSetAssignment assignment = assignments.get(i);
            Pair<String, ExprNode> possibleAssignment = ExprNodeUtilityRich.checkGetAssignmentToProp(assignment.getExpression());
            if (possibleAssignment != null) {
                TypeWidener widener;
                String propertyName = possibleAssignment.getFirst();
                EventPropertyDescriptor writableProperty = eventTypeSPI.getWritableProperty(propertyName);
                if (writableProperty == null) {
                    Pair<String, EventPropertyDescriptor> nameWriteablePair = EventBeanUpdateHelperFactory.checkIndexedOrMappedProp(possibleAssignment.getFirst(), updatedWindowOrTableName, updatedAlias, eventTypeSPI);
                    propertyName = nameWriteablePair.getFirst();
                    writableProperty = nameWriteablePair.getSecond();
                }
                ExprEvaluator evaluator = ExprNodeCompiler.allocateEvaluator(possibleAssignment.getSecond().getForge(), eventAdapterService.getEngineImportService(), EventBeanUpdateHelperFactory.class, isFireAndForget, statementName);
                EventPropertyWriter writers = eventTypeSPI.getWriter(propertyName);
                boolean notNullableField = writableProperty.getPropertyType().isPrimitive();
                properties.add(propertyName);
                try {
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(possibleAssignment.getSecond()), possibleAssignment.getSecond().getForge().getEvaluationType(), writableProperty.getPropertyType(), propertyName, false, typeWidenerCustomizer, statementName, engineURI);
                }
                catch (TypeWidenerException ex) {
                    throw new ExprValidationException(ex.getMessage(), ex);
                }
                if (optionalTriggeringEventType != null && possibleAssignment.getSecond() instanceof ExprIdentNode) {
                    ExprIdentNode node = (ExprIdentNode)possibleAssignment.getSecond();
                    FragmentEventType fragmentRHS = optionalTriggeringEventType.getFragmentType(node.getResolvedPropertyName());
                    FragmentEventType fragmentLHS = eventTypeSPI.getFragmentType(possibleAssignment.getFirst());
                    if (fragmentRHS != null && fragmentLHS != null && !EventTypeUtility.isTypeOrSubTypeOf(fragmentRHS.getFragmentType(), fragmentLHS.getFragmentType())) {
                        throw new ExprValidationException("Invalid assignment to property '" + possibleAssignment.getFirst() + "' event type '" + fragmentLHS.getFragmentType().getName() + "' from event type '" + fragmentRHS.getFragmentType().getName() + "'");
                    }
                }
                updateItem = new EventBeanUpdateItem(evaluator, propertyName, writers, notNullableField, widener);
            } else {
                ExprEvaluator evaluator = ExprNodeCompiler.allocateEvaluator(assignment.getExpression().getForge(), eventAdapterService.getEngineImportService(), EventBeanUpdateHelperFactory.class, isFireAndForget, statementName);
                updateItem = new EventBeanUpdateItem(evaluator, null, null, false, null);
            }
            updateItems.add(updateItem);
        }
        if (isCopyOnWrite) {
            ArrayList propertiesUniqueList = new ArrayList(new HashSet(properties));
            String[] propertiesArray = propertiesUniqueList.toArray(new String[propertiesUniqueList.size()]);
            copyMethod = eventTypeSPI.getCopyMethod(propertiesArray);
            if (copyMethod == null) {
                throw new ExprValidationException("Event type does not support event bean copy");
            }
        } else {
            copyMethod = null;
            Set<String> propertiesInitialValue = EventBeanUpdateHelperFactory.determinePropertiesInitialValue(assignments);
            if (!propertiesInitialValue.isEmpty()) {
                String[] propertiesInitialValueArray = propertiesInitialValue.toArray(new String[propertiesInitialValue.size()]);
                copyMethod = eventTypeSPI.getCopyMethod(propertiesInitialValueArray);
            }
        }
        EventBeanUpdateItem[] updateItemsArray = updateItems.toArray(new EventBeanUpdateItem[updateItems.size()]);
        return new EventBeanUpdateHelper(copyMethod, updateItemsArray);
    }

    private static Set<String> determinePropertiesInitialValue(List<OnTriggerSetAssignment> assignments) {
        HashSet<String> props = new HashSet<String>();
        ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
        for (OnTriggerSetAssignment assignment : assignments) {
            if (assignment.getExpression() instanceof ExprEqualsNode) {
                assignment.getExpression().getChildNodes()[1].accept(visitor);
            } else {
                assignment.getExpression().accept(visitor);
            }
            for (ExprIdentNode node : visitor.getExprProperties()) {
                if (node.getStreamId() != 2) continue;
                props.add(node.getResolvedPropertyName());
            }
        }
        return props;
    }

    private static Pair<String, EventPropertyDescriptor> checkIndexedOrMappedProp(String propertyName, String updatedWindowOrTableName, String namedWindowAlias, EventTypeSPI eventTypeSPI) throws ExprValidationException {
        String name;
        String prefix;
        EventPropertyDescriptor writableProperty = null;
        int indexDot = propertyName.indexOf(".");
        if (namedWindowAlias != null && indexDot != -1) {
            prefix = StringValue.unescapeBacktick(propertyName.substring(0, indexDot));
            name = propertyName.substring(indexDot + 1);
            if (prefix.equals(namedWindowAlias)) {
                writableProperty = eventTypeSPI.getWritableProperty(name);
                propertyName = name;
            }
        }
        if (writableProperty == null && indexDot != -1) {
            prefix = propertyName.substring(0, indexDot);
            name = propertyName.substring(indexDot + 1);
            if (prefix.equals(updatedWindowOrTableName)) {
                writableProperty = eventTypeSPI.getWritableProperty(name);
                propertyName = name;
            }
        }
        if (writableProperty == null) {
            throw new ExprValidationException("Property '" + propertyName + "' is not available for write access");
        }
        return new Pair<String, Object>(propertyName, writableProperty);
    }
}

