/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.onaction;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategy;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.onaction.TableOnView;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TableOnViewBase
extends ViewSupport
implements StopCallback,
TableOnView {
    private static final Logger log = LoggerFactory.getLogger(TableOnViewBase.class);
    protected final SubordWMatchExprLookupStrategy lookupStrategy;
    protected final TableStateInstance tableStateInstance;
    protected final ExprEvaluatorContext exprEvaluatorContext;
    protected final TableMetadata metadata;
    protected final boolean acquireWriteLock;

    protected TableOnViewBase(SubordWMatchExprLookupStrategy lookupStrategy, TableStateInstance tableStateInstance, ExprEvaluatorContext exprEvaluatorContext, TableMetadata metadata, boolean acquireWriteLock) {
        this.lookupStrategy = lookupStrategy;
        this.tableStateInstance = tableStateInstance;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.metadata = metadata;
        this.acquireWriteLock = acquireWriteLock;
    }

    public abstract void handleMatching(EventBean[] var1, EventBean[] var2);

    @Override
    public void stop() {
        log.debug(".stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null) {
            return;
        }
        if (this.acquireWriteLock) {
            this.tableStateInstance.getTableLevelRWLock().writeLock().lock();
            try {
                EventBean[] eventsFound = this.lookupStrategy.lookup(newData, this.exprEvaluatorContext);
                this.handleMatching(newData, eventsFound);
            }
            finally {
                this.tableStateInstance.getTableLevelRWLock().writeLock().unlock();
            }
        }
        this.tableStateInstance.getTableLevelRWLock().readLock().lock();
        try {
            EventBean[] eventsFound = this.lookupStrategy.lookup(newData, this.exprEvaluatorContext);
            this.handleMatching(newData, eventsFound);
        }
        finally {
            this.tableStateInstance.getTableLevelRWLock().readLock().unlock();
        }
    }

    public ExprEvaluatorContext getExprEvaluatorContext() {
        return this.exprEvaluatorContext;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return CollectionUtil.NULL_EVENT_ITERATOR;
    }

    @Override
    public EventType getEventType() {
        return this.metadata.getPublicEventType();
    }
}

