/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.mgmt;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataInternalEventToPublic;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;

public class TableStateViewablePublic
extends ViewSupport {
    private final TableMetadata tableMetadata;
    private final TableStateInstance tableStateInstance;

    public TableStateViewablePublic(TableMetadata tableMetadata, TableStateInstance tableStateInstance) {
        this.tableMetadata = tableMetadata;
        this.tableStateInstance = tableStateInstance;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
    }

    @Override
    public EventType getEventType() {
        return this.tableMetadata.getPublicEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new TableToPublicIterator(this.tableStateInstance);
    }

    private static class TableToPublicIterator
    implements Iterator<EventBean> {
        private final TableMetadataInternalEventToPublic eventToPublic;
        private final Iterator<EventBean> iterator;
        private final TableStateInstance tableStateInstance;

        private TableToPublicIterator(TableStateInstance tableStateInstance) {
            this.eventToPublic = tableStateInstance.getTableMetadata().getEventToPublic();
            this.iterator = tableStateInstance.getEventCollection().iterator();
            this.tableStateInstance = tableStateInstance;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public EventBean next() {
            EventBean event = this.iterator.next();
            return this.eventToPublic.convert(event, null, true, this.tableStateInstance.getAgentInstanceContext());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

