/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.mgmt;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.access.AggregationServicePassThru;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableAsSet;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.EventTableOrganizationType;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleUnique;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableUnique;
import com.espertech.esper.epl.lookup.EventTableIndexRepository;
import com.espertech.esper.epl.lookup.EventTableIndexRepositoryEntry;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumn;
import com.espertech.esper.epl.table.mgmt.TableServiceUtil;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceGrouped;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import com.espertech.esper.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TableStateInstanceGroupedImpl
extends TableStateInstance
implements TableStateInstanceGrouped {
    private final Map<Object, ObjectArrayBackedEventBean> rows = new HashMap<Object, ObjectArrayBackedEventBean>();
    private final IndexMultiKey primaryIndexKey;

    public TableStateInstanceGroupedImpl(TableMetadata tableMetadata, AgentInstanceContext agentInstanceContext) {
        super(tableMetadata, agentInstanceContext);
        EventTableAsSet table;
        ArrayList<EventPropertyGetter> indexGetters = new ArrayList<EventPropertyGetter>();
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Map.Entry<String, TableMetadataColumn> entry : tableMetadata.getTableColumns().entrySet()) {
            if (!entry.getValue().isKey()) continue;
            keyNames.add(entry.getKey());
            indexGetters.add(tableMetadata.getInternalEventType().getGetter(entry.getKey()));
        }
        String tableName = "primary-" + tableMetadata.getTableName();
        EventTableOrganization organization = new EventTableOrganization(tableName, true, false, 0, CollectionUtil.toArray(keyNames), EventTableOrganizationType.HASH);
        if (indexGetters.size() == 1) {
            Map<Object, EventBean> tableMap = this.rows;
            table = new PropertyIndexedEventTableSingleUnique((EventPropertyGetter)indexGetters.get(0), organization, tableMap);
        } else {
            EventPropertyGetter[] getters = indexGetters.toArray(new EventPropertyGetter[indexGetters.size()]);
            Map<Object, ObjectArrayBackedEventBean> tableMap = this.rows;
            table = new PropertyIndexedEventTableUnique(getters, organization, tableMap);
        }
        Pair<int[], IndexMultiKey> pair = TableServiceUtil.getIndexMultikeyForKeys(tableMetadata.getTableColumns(), tableMetadata.getInternalEventType());
        this.primaryIndexKey = pair.getSecond();
        this.indexRepository.addIndex(this.primaryIndexKey, new EventTableIndexRepositoryEntry(tableName, table));
    }

    @Override
    public EventTable getIndex(String indexName) {
        if (indexName.equals(this.tableMetadata.getTableName())) {
            return this.indexRepository.getIndexByDesc(this.primaryIndexKey);
        }
        return this.indexRepository.getExplicitIndexByName(indexName);
    }

    public Map<Object, ObjectArrayBackedEventBean> getRows() {
        return this.rows;
    }

    @Override
    public void addEvent(EventBean theEvent) {
        try {
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(theEvent, (ExprEvaluatorContext)this.agentInstanceContext);
            }
        }
        catch (EPException ex) {
            for (EventTable table : this.indexRepository.getTables()) {
                table.remove(theEvent, (ExprEvaluatorContext)this.agentInstanceContext);
            }
            throw ex;
        }
    }

    @Override
    public void deleteEvent(EventBean matchingEvent) {
        for (EventTable table : this.indexRepository.getTables()) {
            table.remove(matchingEvent, (ExprEvaluatorContext)this.agentInstanceContext);
        }
    }

    @Override
    public Iterable<EventBean> getIterableTableScan() {
        return new PrimaryIndexIterable(this.rows);
    }

    @Override
    public void addExplicitIndex(String explicitIndexName, QueryPlanIndexItem explicitIndexDesc, boolean isRecoveringResilient, boolean allowIndexExists) throws ExprValidationException {
        this.indexRepository.validateAddExplicitIndex(explicitIndexName, explicitIndexDesc, this.tableMetadata.getInternalEventType(), new PrimaryIndexIterable(this.rows), this.getAgentInstanceContext(), isRecoveringResilient || allowIndexExists, null);
    }

    @Override
    public String[] getSecondaryIndexes() {
        return this.indexRepository.getExplicitIndexNames();
    }

    @Override
    public EventTableIndexRepository getIndexRepository() {
        return this.indexRepository;
    }

    @Override
    public Collection<EventBean> getEventCollection() {
        return this.rows.values();
    }

    @Override
    public ObjectArrayBackedEventBean getRowForGroupKey(Object groupKey) {
        return this.rows.get(groupKey);
    }

    @Override
    public Set<Object> getGroupKeys() {
        return this.rows.keySet();
    }

    @Override
    public void clear() {
        this.clearInstance();
    }

    @Override
    public void clearInstance() {
        this.rows.clear();
        for (EventTable table : this.indexRepository.getTables()) {
            table.destroy();
        }
    }

    @Override
    public void destroyInstance() {
        this.clearInstance();
    }

    @Override
    public ObjectArrayBackedEventBean getCreateRowIntoTable(Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        ObjectArrayBackedEventBean bean = this.getRows().get(groupByKey);
        if (bean != null) {
            return bean;
        }
        ObjectArrayBackedEventBean row = this.tableMetadata.getRowFactory().makeOA(exprEvaluatorContext.getAgentInstanceId(), groupByKey, null, this.getAggregationServicePassThru());
        this.addEvent(row);
        return row;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public AggregationServicePassThru getAggregationServicePassThru() {
        return null;
    }

    private static class PrimaryIndexIterable
    implements Iterable<EventBean> {
        private final Map<Object, ObjectArrayBackedEventBean> rows;

        private PrimaryIndexIterable(Map<Object, ObjectArrayBackedEventBean> rows) {
            this.rows = rows;
        }

        @Override
        public Iterator<EventBean> iterator() {
            return this.rows.values().iterator();
        }
    }
}

