/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import java.io.Serializable;
import java.util.List;

public abstract class ObjectSpec
implements Serializable {
    private final String objectNamespace;
    private final String objectName;
    private final List<ExprNode> objectParameters;
    private static final long serialVersionUID = 8376856305427395086L;

    public ObjectSpec(String namespace, String objectName, List<ExprNode> objectParameters) {
        this.objectNamespace = namespace;
        this.objectName = objectName;
        this.objectParameters = objectParameters;
    }

    public String getObjectNamespace() {
        return this.objectNamespace;
    }

    public final String getObjectName() {
        return this.objectName;
    }

    public final List<ExprNode> getObjectParameters() {
        return this.objectParameters;
    }

    public final boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ObjectSpec other = (ObjectSpec)otherObject;
        if (!this.objectName.equals(other.objectName)) {
            return false;
        }
        if (this.objectParameters.size() != other.objectParameters.size()) {
            return false;
        }
        int index = 0;
        for (ExprNode thisParam : this.objectParameters) {
            ExprNode otherParam = other.objectParameters.get(index);
            ++index;
            if (ExprNodeUtilityCore.deepEquals(thisParam, otherParam, false)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.objectNamespace.hashCode();
        result = 31 * result + this.objectName.hashCode();
        return result;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("objectName=");
        buffer.append(this.objectName);
        buffer.append("  objectParameters=(");
        int delimiter = 32;
        if (this.objectParameters != null) {
            for (ExprNode param : this.objectParameters) {
                buffer.append((char)delimiter);
                buffer.append(ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(param));
                delimiter = 44;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }
}

