/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.hook.EPLScriptContext;
import com.espertech.esper.epl.core.engineimport.EngineImportException;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.script.ExprNodeScriptEvalJSR223;
import com.espertech.esper.epl.script.ExprNodeScriptEvalMVEL;
import com.espertech.esper.epl.script.ExprNodeScriptEvaluator;
import com.espertech.esper.epl.script.jsr223.ExpressionScriptCompiledJSR223;
import com.espertech.esper.epl.script.jsr223.JSR223Helper;
import com.espertech.esper.epl.script.mvel.ExpressionScriptCompiledMVEL;
import com.espertech.esper.epl.script.mvel.MVELHelper;
import com.espertech.esper.epl.spec.ExpressionScriptCompiled;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.script.CompiledScript;

public class ExprNodeScript
extends ExprNodeBase
implements ExprNodeInnerNodeProvider {
    private static final long serialVersionUID = 2661218104424440161L;
    public static final String CONTEXT_BINDING_NAME = "epl";
    private final String defaultDialect;
    private final ExpressionScriptProvided script;
    private List<ExprNode> parameters;
    private transient ExprNodeScriptEvaluator evaluator;

    public ExprNodeScript(String defaultDialect, ExpressionScriptProvided script, List<ExprNode> parameters) {
        this.defaultDialect = defaultDialect;
        this.script = script;
        this.parameters = parameters;
    }

    @Override
    public ExprForge getForge() {
        return this.evaluator;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return this.parameters;
    }

    public ExprNodeScriptEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    public ExprNodeScriptEvaluator getScriptExprEvaluator() {
        return this.evaluator;
    }

    public List<ExprNode> getParameters() {
        return this.parameters;
    }

    public String getEventTypeNameAnnotation() {
        return this.script.getOptionalEventTypeName();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.script.getName());
        ExprNodeUtilityCore.toExpressionStringIncludeParen(this.parameters, writer);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    public ExpressionScriptProvided getScript() {
        return this.script;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprNodeScript that = (ExprNodeScript)node;
        if (this.script != null ? !this.script.equals(that.script) : that.script != null) {
            return false;
        }
        return ExprNodeUtilityCore.deepEquals(this.parameters, that.parameters);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class returnType;
        if (this.evaluator != null) {
            return null;
        }
        if (this.script.getParameterNames().size() != this.parameters.size()) {
            throw new ExprValidationException("Invalid number of parameters for script '" + this.script.getName() + "', expected " + this.script.getParameterNames().size() + " parameters but received " + this.parameters.size() + " parameters");
        }
        ArrayList<ExprNode> validatedParameters = new ArrayList<ExprNode>();
        for (ExprNode expr : this.parameters) {
            validatedParameters.add(ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.SCRIPTPARAMS, expr, validationContext));
        }
        String[] inputParamNames = new String[this.script.getParameterNames().size()];
        ExprForge[] forges = new ExprForge[this.script.getParameterNames().size()];
        for (int i = 0; i < this.script.getParameterNames().size(); ++i) {
            inputParamNames[i] = this.script.getParameterNames().get(i);
            forges[i] = ((ExprNode)validatedParameters.get(i)).getForge();
        }
        this.parameters = validatedParameters;
        if (this.script.getCompiled() == null) {
            this.compileScript(forges, validationContext.getEngineImportService());
        }
        Class declaredReturnType = this.getDeclaredReturnType(this.script.getOptionalReturnTypeName(), validationContext);
        if (this.script.isOptionalReturnTypeIsArray() && declaredReturnType != null) {
            declaredReturnType = JavaClassHelper.getArrayType(declaredReturnType);
        }
        if (this.script.getCompiled().getKnownReturnType() == null && this.script.getOptionalReturnTypeName() == null) {
            returnType = Object.class;
        } else if (this.script.getCompiled().getKnownReturnType() != null) {
            if (declaredReturnType == null) {
                returnType = this.script.getCompiled().getKnownReturnType();
            } else {
                Class knownReturnType = this.script.getCompiled().getKnownReturnType();
                if (!(declaredReturnType.isArray() && knownReturnType.isArray() || JavaClassHelper.isAssignmentCompatible(knownReturnType, declaredReturnType))) {
                    throw new ExprValidationException("Return type and declared type not compatible for script '" + this.script.getName() + "', known return type is " + knownReturnType.getName() + " versus declared return type " + declaredReturnType.getName());
                }
                returnType = declaredReturnType;
            }
        } else {
            returnType = declaredReturnType;
        }
        if (returnType == null) {
            returnType = Object.class;
        }
        EventType eventTypeCollection = null;
        if (this.script.getOptionalEventTypeName() != null) {
            if (returnType.isArray() && returnType.getComponentType() == EventBean.class) {
                eventTypeCollection = EventTypeUtility.requireEventType("Script", this.script.getName(), validationContext.getEventAdapterService(), this.script.getOptionalEventTypeName());
            } else {
                throw new ExprValidationException(EventTypeUtility.disallowedAtTypeMessage());
            }
        }
        this.prepareEvaluator(validationContext.getStatementName(), inputParamNames, forges, returnType, eventTypeCollection);
        return null;
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtilityCore.acceptParams(visitor, this.parameters);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtilityCore.acceptParams(visitor, this.parameters);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtilityCore.acceptParams(visitor, this.parameters, this);
    }

    private void compileScript(ExprForge[] forges, EngineImportService engineImportService) throws ExprValidationException {
        ExpressionScriptCompiled compiled;
        String dialect;
        String string = dialect = this.script.getOptionalDialect() == null ? this.defaultDialect : this.script.getOptionalDialect();
        if (dialect.toLowerCase(Locale.ENGLISH).trim().equals("mvel")) {
            HashMap<String, Class> mvelInputParamTypes = new HashMap<String, Class>();
            for (int i = 0; i < this.script.getParameterNames().size(); ++i) {
                String mvelParamName = this.script.getParameterNames().get(i);
                mvelInputParamTypes.put(mvelParamName, forges[i].getEvaluationType());
            }
            mvelInputParamTypes.put(CONTEXT_BINDING_NAME, EPLScriptContext.class);
            compiled = MVELHelper.compile(this.script.getName(), this.script.getExpression(), mvelInputParamTypes, engineImportService);
        } else {
            CompiledScript compiledScript = JSR223Helper.verifyCompileScript(this.script, dialect);
            compiled = new ExpressionScriptCompiledJSR223(compiledScript);
        }
        this.script.setCompiled(compiled);
    }

    private void prepareEvaluator(String statementName, String[] inputParamNames, ExprForge[] evaluators, Class returnType, EventType eventTypeCollection) {
        if (this.script.getCompiled() instanceof ExpressionScriptCompiledMVEL) {
            ExpressionScriptCompiledMVEL mvel = (ExpressionScriptCompiledMVEL)this.script.getCompiled();
            this.evaluator = new ExprNodeScriptEvalMVEL(this, statementName, inputParamNames, evaluators, returnType, eventTypeCollection, mvel.getCompiled());
        } else {
            ExpressionScriptCompiledJSR223 jsr223 = (ExpressionScriptCompiledJSR223)this.script.getCompiled();
            this.evaluator = new ExprNodeScriptEvalJSR223(this, statementName, inputParamNames, evaluators, returnType, eventTypeCollection, jsr223.getCompiled());
        }
    }

    private Class getDeclaredReturnType(String returnTypeName, ExprValidationContext validationContext) throws ExprValidationException {
        if (returnTypeName == null) {
            return null;
        }
        if (returnTypeName.equals("void")) {
            return null;
        }
        Class returnType = JavaClassHelper.getClassForSimpleName(returnTypeName, validationContext.getEngineImportService().getClassForNameProvider());
        if (returnType != null) {
            return returnType;
        }
        if (returnTypeName.equals("EventBean")) {
            return EventBean.class;
        }
        try {
            return validationContext.getEngineImportService().resolveClass(returnTypeName, false);
        }
        catch (EngineImportException e1) {
            throw new ExprValidationException("Failed to resolve return type '" + returnTypeName + "' specified for script '" + this.script.getName() + "'");
        }
    }
}

