/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.property.ContainedEventEval;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEvaluatorAccumulative {
    private static final Logger log = LoggerFactory.getLogger(PropertyEvaluatorAccumulative.class);
    private final ContainedEventEval[] containedEventEvals;
    private final FragmentEventType[] fragmentEventType;
    private final ExprEvaluator[] whereClauses;
    private final int lastLevel;
    private final int levels;
    private final List<String> propertyNames;

    public PropertyEvaluatorAccumulative(ContainedEventEval[] containedEventEvals, FragmentEventType[] fragmentEventType, ExprEvaluator[] whereClauses, List<String> propertyNames) {
        this.fragmentEventType = fragmentEventType;
        this.containedEventEvals = containedEventEvals;
        this.whereClauses = whereClauses;
        this.lastLevel = fragmentEventType.length - 1;
        this.levels = fragmentEventType.length + 1;
        this.propertyNames = propertyNames;
    }

    public ArrayDeque<EventBean[]> getAccumulative(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayDeque<EventBean[]> resultEvents = new ArrayDeque<EventBean[]>();
        EventBean[] eventsPerStream = new EventBean[this.levels];
        eventsPerStream[0] = theEvent;
        this.populateEvents(eventsPerStream, theEvent, 0, resultEvents, exprEvaluatorContext);
        if (resultEvents.isEmpty()) {
            return null;
        }
        return resultEvents;
    }

    private void populateEvents(EventBean[] eventsPerStream, EventBean branch, int level, Collection<EventBean[]> events, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.containedEventEvals[level].getFragment(branch, eventsPerStream, exprEvaluatorContext);
            if (this.fragmentEventType[level].isIndexed()) {
                EventBean[] fragments = (EventBean[])result;
                if (level == this.lastLevel) {
                    if (this.whereClauses[level] != null) {
                        EventBean[] eventBeanArray = fragments;
                        int n = eventBeanArray.length;
                        for (int i = 0; i < n; ++i) {
                            EventBean theEvent;
                            eventsPerStream[level + 1] = theEvent = eventBeanArray[i];
                            if (!ExprNodeUtilityCore.applyFilterExpression(this.whereClauses[level], eventsPerStream, exprEvaluatorContext)) continue;
                            EventBean[] eventsPerRow = new EventBean[this.levels];
                            System.arraycopy(eventsPerStream, 0, eventsPerRow, 0, this.levels);
                            events.add(eventsPerRow);
                        }
                    } else {
                        EventBean[] eventBeanArray = fragments;
                        int n = eventBeanArray.length;
                        for (int i = 0; i < n; ++i) {
                            EventBean theEvent;
                            eventsPerStream[level + 1] = theEvent = eventBeanArray[i];
                            EventBean[] eventsPerRow = new EventBean[this.levels];
                            System.arraycopy(eventsPerStream, 0, eventsPerRow, 0, this.levels);
                            events.add(eventsPerRow);
                        }
                    }
                } else if (this.whereClauses[level] != null) {
                    EventBean[] eventBeanArray = fragments;
                    int n = eventBeanArray.length;
                    for (int i = 0; i < n; ++i) {
                        EventBean next;
                        eventsPerStream[level + 1] = next = eventBeanArray[i];
                        if (!ExprNodeUtilityCore.applyFilterExpression(this.whereClauses[level], eventsPerStream, exprEvaluatorContext)) continue;
                        this.populateEvents(eventsPerStream, next, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    EventBean[] eventBeanArray = fragments;
                    int n = eventBeanArray.length;
                    for (int i = 0; i < n; ++i) {
                        EventBean next;
                        eventsPerStream[level + 1] = next = eventBeanArray[i];
                        this.populateEvents(eventsPerStream, next, level + 1, events, exprEvaluatorContext);
                    }
                }
            } else {
                EventBean fragment = (EventBean)result;
                if (level == this.lastLevel) {
                    if (this.whereClauses[level] != null) {
                        eventsPerStream[level + 1] = fragment;
                        if (ExprNodeUtilityCore.applyFilterExpression(this.whereClauses[level], eventsPerStream, exprEvaluatorContext)) {
                            EventBean[] eventsPerRow = new EventBean[this.levels];
                            System.arraycopy(eventsPerStream, 0, eventsPerRow, 0, this.levels);
                            events.add(eventsPerRow);
                        }
                    } else {
                        eventsPerStream[level + 1] = fragment;
                        EventBean[] eventsPerRow = new EventBean[this.levels];
                        System.arraycopy(eventsPerStream, 0, eventsPerRow, 0, this.levels);
                        events.add(eventsPerRow);
                    }
                } else if (this.whereClauses[level] != null) {
                    eventsPerStream[level + 1] = fragment;
                    if (ExprNodeUtilityCore.applyFilterExpression(this.whereClauses[level], eventsPerStream, exprEvaluatorContext)) {
                        this.populateEvents(eventsPerStream, fragment, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    eventsPerStream[level + 1] = fragment;
                    this.populateEvents(eventsPerStream, fragment, level + 1, events, exprEvaluatorContext);
                }
            }
        }
        catch (RuntimeException ex) {
            log.error("Unexpected error evaluating property expression for event of type '" + branch.getEventType().getName() + "' and property '" + this.propertyNames.get(level + 1) + "': " + ex.getMessage(), (Throwable)ex);
        }
    }
}

