/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.client.ConfigurationPlugInAggregationMultiFunction;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.epl.expression.dot.ExprDotNode;
import com.espertech.esper.epl.expression.dot.ExprDotNodeImpl;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.expression.table.ExprTableAccessNodeKeys;
import com.espertech.esper.epl.expression.table.ExprTableAccessNodeSubprop;
import com.espertech.esper.epl.expression.table.ExprTableAccessNodeSubpropAccessor;
import com.espertech.esper.epl.expression.table.ExprTableAccessNodeTopLevel;
import com.espertech.esper.epl.parse.ASTAggregationHelper;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.plugin.PlugInAggregationMultiFunctionFactory;
import com.espertech.esper.util.LazyAllocatedMap;
import com.espertech.esper.util.StringValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ASTTableExprHelper {
    public static void addTableExpressionReference(StatementSpecRaw statementSpec, ExprTableAccessNode tableNode) {
        if (statementSpec.getTableExpressions() == null) {
            statementSpec.setTableExpressions(new HashSet<ExprTableAccessNode>());
        }
        statementSpec.getTableExpressions().add(tableNode);
    }

    public static void addTableExpressionReference(StatementSpecRaw statementSpec, Set<ExprTableAccessNode> tableNodes) {
        if (tableNodes == null || tableNodes.isEmpty()) {
            return;
        }
        if (statementSpec.getTableExpressions() == null) {
            statementSpec.setTableExpressions(new HashSet<ExprTableAccessNode>());
        }
        statementSpec.getTableExpressions().addAll(tableNodes);
    }

    public static Pair<ExprTableAccessNode, ExprDotNode> checkTableNameGetExprForSubproperty(TableService tableService, String tableName, String subproperty) {
        TableMetadata metadata = tableService.getTableMetadata(tableName);
        if (metadata == null) {
            return null;
        }
        int index = StringValue.unescapedIndexOfDot(subproperty);
        if (index == -1) {
            if (metadata.getKeyTypes().length > 0) {
                return null;
            }
            ExprTableAccessNodeSubprop tableNode = new ExprTableAccessNodeSubprop(tableName, subproperty);
            return new Pair<ExprTableAccessNodeSubprop, Object>(tableNode, null);
        }
        ArrayList<ExprChainedSpec> chainedSpecs = new ArrayList<ExprChainedSpec>(1);
        chainedSpecs.add(new ExprChainedSpec(subproperty.substring(index + 1), Collections.emptyList(), true));
        ExprTableAccessNodeSubprop tableNode = new ExprTableAccessNodeSubprop(tableName, subproperty.substring(0, index));
        ExprDotNodeImpl dotNode = new ExprDotNodeImpl(chainedSpecs, false, false);
        dotNode.addChildNode(tableNode);
        return new Pair<ExprTableAccessNode, ExprDotNode>(tableNode, dotNode);
    }

    public static ExprTableAccessNode checkTableNameGetExprForProperty(TableService tableService, String propertyName) {
        int index = StringValue.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            if (tableService.getTableMetadata(propertyName) != null) {
                return new ExprTableAccessNodeTopLevel(propertyName);
            }
            return null;
        }
        String tableName = ASTUtil.unescapeDot(propertyName.substring(0, index));
        if (tableService.getTableMetadata(tableName) == null) {
            return null;
        }
        String sub = propertyName.substring(index + 1, propertyName.length());
        return new ExprTableAccessNodeSubprop(tableName, sub);
    }

    public static Pair<ExprTableAccessNode, List<ExprChainedSpec>> checkTableNameGetLibFunc(TableService tableService, EngineImportService engineImportService, LazyAllocatedMap<ConfigurationPlugInAggregationMultiFunction, PlugInAggregationMultiFunctionFactory> plugInAggregations, String engineURI, String classIdent, List<ExprChainedSpec> chain) {
        int index = StringValue.unescapedIndexOfDot(classIdent);
        if (index == -1) {
            if (tableService.getTableMetadata(classIdent) == null) {
                return null;
            }
            String funcName = chain.get(1).getName();
            if (funcName.toLowerCase(Locale.ENGLISH).equals("keys")) {
                List<ExprChainedSpec> subchain = chain.subList(2, chain.size());
                ExprTableAccessNodeKeys node = new ExprTableAccessNodeKeys(classIdent);
                return new Pair<ExprTableAccessNode, List<ExprChainedSpec>>(node, subchain);
            }
            throw ASTWalkException.from("Invalid use of variable '" + classIdent + "', unrecognized use of function '" + funcName + "', expected 'keys()'");
        }
        String tableName = ASTUtil.unescapeDot(classIdent.substring(0, index));
        if (tableService.getTableMetadata(tableName) == null) {
            return null;
        }
        String sub = classIdent.substring(index + 1, classIdent.length());
        return ASTTableExprHelper.handleTable(engineImportService, plugInAggregations, engineURI, tableName, sub, chain);
    }

    public static Pair<ExprTableAccessNode, List<ExprChainedSpec>> getTableExprChainable(EngineImportService engineImportService, LazyAllocatedMap<ConfigurationPlugInAggregationMultiFunction, PlugInAggregationMultiFunctionFactory> plugInAggregations, String engineURI, String tableName, List<ExprChainedSpec> chain) {
        String subpropName = chain.get(0).getName();
        if (chain.size() == 1) {
            chain.remove(0);
            ExprTableAccessNodeSubprop tableNode = new ExprTableAccessNodeSubprop(tableName, subpropName);
            return new Pair<ExprTableAccessNode, List<ExprChainedSpec>>(tableNode, chain);
        }
        return ASTTableExprHelper.handleTable(engineImportService, plugInAggregations, engineURI, tableName, subpropName, chain);
    }

    private static Pair<ExprTableAccessNode, List<ExprChainedSpec>> handleTable(EngineImportService engineImportService, LazyAllocatedMap<ConfigurationPlugInAggregationMultiFunction, PlugInAggregationMultiFunctionFactory> plugInAggregations, String engineURI, String tableName, String sub, List<ExprChainedSpec> chain) {
        ExprTableAccessNode node = new ExprTableAccessNodeSubprop(tableName, sub);
        List<ExprChainedSpec> subchain = chain.subList(1, chain.size());
        String candidateAccessor = subchain.get(0).getName();
        ExprAggregateNodeBase exprNode = (ExprAggregateNodeBase)ASTAggregationHelper.tryResolveAsAggregation(engineImportService, false, candidateAccessor, plugInAggregations, engineURI);
        if (exprNode != null) {
            node = new ExprTableAccessNodeSubpropAccessor(tableName, sub, exprNode);
            exprNode.addChildNodes(subchain.get(0).getParameters());
            subchain.remove(0);
        }
        return new Pair<ExprTableAccessNode, List<ExprChainedSpec>>(node, subchain);
    }
}

