/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadIndexVisitor;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.fafquery.FireAndForgetQueryExec;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableUtil;
import com.espertech.esper.epl.lookup.EventTableIndexMetadata;
import com.espertech.esper.epl.lookup.EventTableIndexMetadataEntry;
import com.espertech.esper.epl.lookup.EventTableIndexRepository;
import com.espertech.esper.epl.lookup.EventTableIndexRepositoryEntry;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategy;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NamedWindowRootViewInstance
extends ViewSupport {
    private final NamedWindowRootView rootView;
    private final AgentInstanceContext agentInstanceContext;
    private final EventTableIndexRepository indexRepository;
    private final Map<SubordWMatchExprLookupStrategy, EventTable[]> tablePerMultiLookup;
    private Iterable<EventBean> dataWindowContents;

    public NamedWindowRootViewInstance(NamedWindowRootView rootView, AgentInstanceContext agentInstanceContext, EventTableIndexMetadata eventTableIndexMetadata) {
        this.rootView = rootView;
        this.agentInstanceContext = agentInstanceContext;
        this.indexRepository = new EventTableIndexRepository(eventTableIndexMetadata);
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry : eventTableIndexMetadata.getIndexes().entrySet()) {
            if (entry.getValue().getQueryPlanIndexItem() == null) continue;
            EventTable index = EventTableUtil.buildIndex(agentInstanceContext, 0, entry.getValue().getQueryPlanIndexItem(), rootView.getEventType(), true, entry.getKey().isUnique(), entry.getValue().getOptionalIndexName(), null, false);
            this.indexRepository.addIndex(entry.getKey(), new EventTableIndexRepositoryEntry(entry.getValue().getOptionalIndexName(), index));
        }
        this.tablePerMultiLookup = new HashMap<SubordWMatchExprLookupStrategy, EventTable[]>();
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    public EventTableIndexRepository getIndexRepository() {
        return this.indexRepository;
    }

    public IndexMultiKey[] getIndexes() {
        return this.indexRepository.getIndexDescriptors();
    }

    public Iterable<EventBean> getDataWindowContents() {
        return this.dataWindowContents;
    }

    public void setDataWindowContents(Iterable<EventBean> dataWindowContents) {
        this.dataWindowContents = dataWindowContents;
    }

    public void removeOldData(EventBean[] oldData) {
        if (this.rootView.getRevisionProcessor() != null) {
            this.rootView.getRevisionProcessor().removeOldData(oldData, this.indexRepository, this.agentInstanceContext);
        } else {
            for (EventTable table : this.indexRepository.getTables()) {
                table.remove(oldData, (ExprEvaluatorContext)this.agentInstanceContext);
            }
        }
    }

    public void addNewData(EventBean[] newData) {
        if (this.rootView.getRevisionProcessor() == null) {
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(newData, (ExprEvaluatorContext)this.agentInstanceContext);
            }
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (this.rootView.getRevisionProcessor() != null) {
            this.rootView.getRevisionProcessor().onUpdate(newData, oldData, this, this.indexRepository);
        } else {
            for (EventTable table : this.indexRepository.getTables()) {
                if (!this.rootView.isChildBatching()) continue;
                table.add(newData, (ExprEvaluatorContext)this.agentInstanceContext);
            }
            this.updateChildren(newData, oldData);
        }
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
    }

    @Override
    public EventType getEventType() {
        return this.rootView.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return null;
    }

    public void destroy() {
        this.indexRepository.destroy();
        this.tablePerMultiLookup.clear();
        if (this.isVirtualDataWindow()) {
            this.getVirtualDataWindow().handleStopWindow();
        }
    }

    public Collection<EventBean> snapshot(QueryGraph queryGraph, Annotation[] annotations) {
        VirtualDWView virtualDataWindow = null;
        if (this.isVirtualDataWindow()) {
            virtualDataWindow = this.getVirtualDataWindow();
        }
        return FireAndForgetQueryExec.snapshot(queryGraph, annotations, virtualDataWindow, this.indexRepository, this.rootView.isQueryPlanLogging(), NamedWindowRootView.getQueryPlanLog(), this.rootView.getEventType().getName(), this.agentInstanceContext);
    }

    public synchronized void addExplicitIndex(String explicitIndexName, QueryPlanIndexItem explicitIndexDesc, boolean isRecoveringResilient) throws ExprValidationException {
        boolean initIndex = this.agentInstanceContext.getStatementContext().getEventTableIndexService().allowInitIndex(isRecoveringResilient);
        Iterable<EventBean> initializeFrom = initIndex ? this.dataWindowContents : CollectionUtil.NULL_EVENT_ITERABLE;
        this.indexRepository.validateAddExplicitIndex(explicitIndexName, explicitIndexDesc, this.rootView.getEventType(), initializeFrom, this.agentInstanceContext, isRecoveringResilient, null);
    }

    public boolean isVirtualDataWindow() {
        return this.getViews()[0] instanceof VirtualDWView;
    }

    public VirtualDWView getVirtualDataWindow() {
        if (!this.isVirtualDataWindow()) {
            return null;
        }
        return (VirtualDWView)((Object)this.getViews()[0]);
    }

    public void postLoad() {
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> iterator = this.dataWindowContents.iterator();
        while (iterator.hasNext()) {
            EventBean event;
            events[0] = event = iterator.next();
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(events, (ExprEvaluatorContext)this.agentInstanceContext);
            }
        }
    }

    public void visitIndexes(StatementAgentInstancePostLoadIndexVisitor visitor) {
        visitor.visit(this.indexRepository.getTables());
    }

    public boolean isQueryPlanLogging() {
        return this.rootView.isQueryPlanLogging();
    }

    public void stop() {
        if (this.isVirtualDataWindow()) {
            this.getVirtualDataWindow().handleStopWindow();
        }
    }
}

