/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.named.NamedWindowConsumerMgmtService;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedWindowConsumerMgmtServiceImpl
implements NamedWindowConsumerMgmtService {
    private static final Logger log = LoggerFactory.getLogger(NamedWindowConsumerMgmtServiceImpl.class);
    public static final NamedWindowConsumerMgmtServiceImpl INSTANCE = new NamedWindowConsumerMgmtServiceImpl();

    private NamedWindowConsumerMgmtServiceImpl() {
    }

    @Override
    public void addConsumer(StatementContext statementContext, NamedWindowConsumerStreamSpec namedSpec) {
        if (log.isDebugEnabled()) {
            log.debug("Statement '" + statementContext.getStatementName() + " registers consumer for '" + namedSpec.getWindowName() + "'");
        }
    }

    @Override
    public void start(String statementName) {
        if (log.isDebugEnabled()) {
            log.debug("Statement '" + statementName + " starts consuming");
        }
    }

    @Override
    public void stop(String statementName) {
        if (log.isDebugEnabled()) {
            log.debug("Statement '" + statementName + " stop consuming");
        }
    }

    @Override
    public void destroy(String statementName) {
        if (log.isDebugEnabled()) {
            log.debug("Statement '" + statementName + " destroyed");
        }
    }

    @Override
    public void removeReferences(String statementName) {
        if (log.isDebugEnabled()) {
            log.debug("Statement '" + statementName + " removing references");
        }
    }
}

