/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.metric;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationMetricsReporting;
import com.espertech.esper.client.EPRuntime;
import com.espertech.esper.client.metric.MetricEvent;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementLifecycleEvent;
import com.espertech.esper.core.service.StatementLifecycleObserver;
import com.espertech.esper.core.service.StatementResultListener;
import com.espertech.esper.epl.metric.MetricEventRouter;
import com.espertech.esper.epl.metric.MetricExec;
import com.espertech.esper.epl.metric.MetricExecEngine;
import com.espertech.esper.epl.metric.MetricExecStatement;
import com.espertech.esper.epl.metric.MetricExecutionContext;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.metric.MetricReportingServiceSPI;
import com.espertech.esper.epl.metric.MetricScheduleService;
import com.espertech.esper.epl.metric.MetricsExecutor;
import com.espertech.esper.epl.metric.MetricsExecutorThreaded;
import com.espertech.esper.epl.metric.MetricsExecutorUnthreaded;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.epl.metric.StatementMetricRepository;
import com.espertech.esper.util.MetricUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricReportingServiceImpl
implements MetricReportingServiceSPI,
MetricEventRouter,
StatementLifecycleObserver {
    private static final Logger log = LoggerFactory.getLogger(MetricReportingServiceImpl.class);
    private final ConfigurationMetricsReporting specification;
    private final String engineUri;
    private volatile MetricExecutionContext executionContext;
    private boolean isScheduled;
    private final MetricScheduleService schedule;
    private final StatementMetricRepository stmtMetricRepository;
    private MetricExecEngine metricExecEngine;
    private MetricExecStatement metricExecStmtGroupDefault;
    private Map<String, MetricExecStatement> statementGroupExecutions;
    private final Map<String, StatementMetricHandle> statementMetricHandles;
    private final MetricsExecutor metricsExecutor;
    private CopyOnWriteArraySet<StatementResultListener> statementOutputHooks;

    public MetricReportingServiceImpl(ConfigurationMetricsReporting specification, String engineUri) {
        if (specification.isEnableMetricsReporting()) {
            MetricUtil.initialize();
        }
        this.specification = specification;
        this.engineUri = engineUri;
        this.schedule = new MetricScheduleService();
        this.stmtMetricRepository = new StatementMetricRepository(engineUri, specification);
        this.statementGroupExecutions = new LinkedHashMap<String, MetricExecStatement>();
        this.statementMetricHandles = new HashMap<String, StatementMetricHandle>();
        this.statementOutputHooks = new CopyOnWriteArraySet();
        this.metricsExecutor = specification.isThreading() ? new MetricsExecutorThreaded(engineUri) : new MetricsExecutorUnthreaded();
    }

    @Override
    public void addStatementResultListener(StatementResultListener listener) {
        this.statementOutputHooks.add(listener);
    }

    @Override
    public void removeStatementResultListener(StatementResultListener listener) {
        this.statementOutputHooks.remove(listener);
    }

    public CopyOnWriteArraySet<StatementResultListener> getStatementOutputHooks() {
        return this.statementOutputHooks;
    }

    @Override
    public void setContext(EPRuntime runtime, EPServicesContext servicesContext) {
        MetricExecutionContext metricsExecutionContext = new MetricExecutionContext(servicesContext, runtime, this.stmtMetricRepository);
        this.metricExecEngine = new MetricExecEngine(this, this.engineUri, this.schedule, this.specification.getEngineInterval());
        this.metricExecStmtGroupDefault = new MetricExecStatement(this, this.schedule, this.specification.getStatementInterval(), 0);
        int countGroups = 1;
        for (Map.Entry<String, ConfigurationMetricsReporting.StmtGroupMetrics> entry : this.specification.getStatementGroups().entrySet()) {
            ConfigurationMetricsReporting.StmtGroupMetrics config = entry.getValue();
            MetricExecStatement metricsExecution = new MetricExecStatement(this, this.schedule, config.getInterval(), countGroups);
            this.statementGroupExecutions.put(entry.getKey(), metricsExecution);
            ++countGroups;
        }
        this.executionContext = metricsExecutionContext;
    }

    @Override
    public void processTimeEvent(long timeEventTime) {
        Long nearestTime;
        if (!MetricReportingPath.isMetricsEnabled) {
            return;
        }
        this.schedule.setTime(timeEventTime);
        if (!this.isScheduled) {
            if (this.executionContext != null) {
                this.scheduleExecutions();
                this.isScheduled = true;
            } else {
                return;
            }
        }
        if ((nearestTime = this.schedule.getNearestTime()) == null || nearestTime > timeEventTime) {
            return;
        }
        ArrayList<MetricExec> executions = new ArrayList<MetricExec>(2);
        this.schedule.evaluate(executions);
        if (executions.isEmpty()) {
            return;
        }
        if (this.executionContext == null) {
            log.debug(".processTimeEvent No execution context");
            return;
        }
        for (MetricExec execution : executions) {
            this.metricsExecutor.execute(execution, this.executionContext);
        }
    }

    @Override
    public void destroy() {
        this.schedule.clear();
        this.metricsExecutor.destroy();
    }

    @Override
    public void route(MetricEvent metricEvent) {
        this.executionContext.getRuntime().sendEvent(metricEvent);
    }

    @Override
    public void accountTime(StatementMetricHandle metricsHandle, long deltaCPU, long deltaWall, int numInputEvents) {
        this.stmtMetricRepository.accountTimes(metricsHandle, deltaCPU, deltaWall, numInputEvents);
    }

    @Override
    public void accountOutput(StatementMetricHandle handle, int numIStream, int numRStream) {
        this.stmtMetricRepository.accountOutput(handle, numIStream, numRStream);
    }

    @Override
    public StatementMetricHandle getStatementHandle(int statementId, String statementName) {
        if (!MetricReportingPath.isMetricsEnabled) {
            return null;
        }
        StatementMetricHandle handle = this.stmtMetricRepository.addStatement(statementName);
        this.statementMetricHandles.put(statementName, handle);
        return handle;
    }

    @Override
    public void observe(StatementLifecycleEvent theEvent) {
        if (!MetricReportingPath.isMetricsEnabled) {
            return;
        }
        if (theEvent.getEventType() == StatementLifecycleEvent.LifecycleEventType.STATECHANGE && theEvent.getStatement().isDestroyed()) {
            this.stmtMetricRepository.removeStatement(theEvent.getStatement().getName());
            this.statementMetricHandles.remove(theEvent.getStatement().getName());
        }
    }

    @Override
    public void setMetricsReportingInterval(String stmtGroupName, long newInterval) {
        if (stmtGroupName == null) {
            this.metricExecStmtGroupDefault.setInterval(newInterval);
            return;
        }
        MetricExecStatement exec = this.statementGroupExecutions.get(stmtGroupName);
        if (exec == null) {
            throw new IllegalArgumentException("Statement group by name '" + stmtGroupName + "' could not be found");
        }
        exec.setInterval(newInterval);
    }

    private boolean isConsiderSchedule(long value) {
        return value > 0L && value < Long.MAX_VALUE;
    }

    @Override
    public void setMetricsReportingStmtDisabled(String statementName) throws ConfigurationException {
        StatementMetricHandle handle = this.statementMetricHandles.get(statementName);
        if (handle == null) {
            throw new ConfigurationException("Statement by name '" + statementName + "' not found in metrics collection");
        }
        handle.setEnabled(false);
    }

    @Override
    public void setMetricsReportingStmtEnabled(String statementName) throws ConfigurationException {
        StatementMetricHandle handle = this.statementMetricHandles.get(statementName);
        if (handle == null) {
            throw new ConfigurationException("Statement by name '" + statementName + "' not found in metrics collection");
        }
        handle.setEnabled(true);
    }

    @Override
    public void setMetricsReportingEnabled() {
        if (!this.specification.isEnableMetricsReporting()) {
            throw new ConfigurationException("Metrics reporting must be enabled through initialization-time configuration");
        }
        this.scheduleExecutions();
        MetricReportingPath.setMetricsEnabled(true);
    }

    @Override
    public void setMetricsReportingDisabled() {
        this.schedule.clear();
        MetricReportingPath.setMetricsEnabled(false);
    }

    private void scheduleExecutions() {
        if (!this.specification.isEnableMetricsReporting()) {
            return;
        }
        if (this.isConsiderSchedule(this.metricExecEngine.getInterval())) {
            this.schedule.add(this.metricExecEngine.getInterval(), this.metricExecEngine);
        }
        if (this.isConsiderSchedule(this.metricExecStmtGroupDefault.getInterval())) {
            this.schedule.add(this.metricExecStmtGroupDefault.getInterval(), this.metricExecStmtGroupDefault);
        }
        for (MetricExecStatement metricsExecution : this.statementGroupExecutions.values()) {
            if (!this.isConsiderSchedule(metricsExecution.getInterval())) continue;
            this.schedule.add(metricsExecution.getInterval(), metricsExecution);
        }
    }
}

