/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import com.espertech.esper.epl.lookup.SubordIndexedTableLookupStrategyProp;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import java.util.Arrays;

public class SubordIndexedTableLookupStrategyPropFactory
implements SubordTableLookupStrategyFactory {
    private final String[] properties;
    private final int[] keyStreamNums;
    private final EventPropertyGetter[] propertyGetters;
    private final LookupStrategyDesc strategyDesc;

    public SubordIndexedTableLookupStrategyPropFactory(boolean isNWOnTrigger, EventType[] eventTypes, int[] keyStreamNumbers, String[] properties) {
        int i;
        this.keyStreamNums = keyStreamNumbers;
        this.properties = properties;
        this.strategyDesc = new LookupStrategyDesc(LookupStrategyType.MULTIPROP, properties);
        this.propertyGetters = new EventPropertyGetter[properties.length];
        for (i = 0; i < keyStreamNumbers.length; ++i) {
            int streamNumber = keyStreamNumbers[i];
            String property = properties[i];
            EventType eventType = eventTypes[streamNumber];
            this.propertyGetters[i] = eventType.getGetter(property);
            if (this.propertyGetters[i] != null) continue;
            throw new IllegalArgumentException("Property named '" + properties[i] + "' is invalid for type " + eventType);
        }
        for (i = 0; i < this.keyStreamNums.length; ++i) {
            int n = i;
            this.keyStreamNums[n] = this.keyStreamNums[n] + (isNWOnTrigger ? 1 : 0);
        }
    }

    @Override
    public SubordTableLookupStrategy makeStrategy(EventTable[] eventTable, VirtualDWView vdw) {
        return new SubordIndexedTableLookupStrategyProp(this.keyStreamNums, this.propertyGetters, (PropertyIndexedEventTable)eventTable[0], this.strategyDesc);
    }

    public String[] getProperties() {
        return this.properties;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " indexProps=" + Arrays.toString(this.properties) + " keyStreamNums=" + Arrays.toString(this.keyStreamNums);
    }
}

