/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import com.espertech.esper.epl.lookup.SubordIndexedTableLookupStrategyExpr;
import com.espertech.esper.epl.lookup.SubordIndexedTableLookupStrategyExprNW;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import java.util.List;

public class SubordIndexedTableLookupStrategyExprFactory
implements SubordTableLookupStrategyFactory {
    protected final ExprEvaluator[] evaluators;
    protected final boolean isNWOnTrigger;
    protected final int numStreamsOuter;
    protected final LookupStrategyDesc strategyDesc;

    public SubordIndexedTableLookupStrategyExprFactory(boolean isNWOnTrigger, int numStreamsOuter, List<SubordPropHashKey> hashKeys) {
        this.evaluators = new ExprEvaluator[hashKeys.size()];
        String[] expressions = new String[this.evaluators.length];
        for (int i = 0; i < hashKeys.size(); ++i) {
            this.evaluators[i] = hashKeys.get(i).getHashKey().getKeyExpr().getForge().getExprEvaluator();
            expressions[i] = ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(hashKeys.get(i).getHashKey().getKeyExpr());
        }
        this.isNWOnTrigger = isNWOnTrigger;
        this.numStreamsOuter = numStreamsOuter;
        this.strategyDesc = new LookupStrategyDesc(LookupStrategyType.MULTIEXPR, expressions);
    }

    @Override
    public SubordTableLookupStrategy makeStrategy(EventTable[] eventTable, VirtualDWView vdw) {
        if (this.isNWOnTrigger) {
            return new SubordIndexedTableLookupStrategyExprNW(this.evaluators, (PropertyIndexedEventTable)eventTable[0], this.strategyDesc);
        }
        return new SubordIndexedTableLookupStrategyExpr(this.numStreamsOuter, this.evaluators, (PropertyIndexedEventTable)eventTable[0], this.strategyDesc);
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " evaluators " + ExprNodeUtilityCore.printEvaluators(this.evaluators);
    }
}

