/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class PropertySortedEventTableIterator
implements Iterator<EventBean> {
    private final Map<Object, Set<EventBean>> window;
    private final Iterator<Object> keyIterator;
    private Iterator<EventBean> currentListIterator;

    public PropertySortedEventTableIterator(Map<Object, Set<EventBean>> window) {
        this.window = window;
        this.keyIterator = window.keySet().iterator();
        if (this.keyIterator.hasNext()) {
            Object initialKey = this.keyIterator.next();
            this.currentListIterator = window.get(initialKey).iterator();
        }
    }

    @Override
    public final EventBean next() {
        if (this.currentListIterator == null) {
            throw new NoSuchElementException();
        }
        EventBean eventBean = this.currentListIterator.next();
        if (!this.currentListIterator.hasNext()) {
            this.currentListIterator = null;
            if (this.keyIterator.hasNext()) {
                Object nextKey = this.keyIterator.next();
                this.currentListIterator = this.window.get(nextKey).iterator();
            }
        }
        return eventBean;
    }

    @Override
    public final boolean hasNext() {
        if (this.currentListIterator == null) {
            return false;
        }
        if (this.currentListIterator.hasNext()) {
            return true;
        }
        this.currentListIterator = null;
        return this.keyIterator.hasNext();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

