/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdent;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.EventTableOrganizationType;
import com.espertech.esper.epl.join.table.PropertySortedEventTable;
import com.espertech.esper.epl.join.table.PropertySortedEventTableImpl;
import com.espertech.esper.event.EventBeanUtility;

public class PropertySortedEventTableFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String propertyName;
    protected final EventPropertyGetter propertyGetter;

    public PropertySortedEventTableFactory(int streamNum, EventType eventType, String propertyName) {
        this.streamNum = streamNum;
        this.propertyName = propertyName;
        this.propertyGetter = EventBeanUtility.getAssertPropertyGetter(eventType, propertyName);
    }

    @Override
    public EventTable[] makeEventTables(EventTableFactoryTableIdent tableIdent, ExprEvaluatorContext exprEvaluatorContext) {
        EventTableOrganization organization = this.getOrganization();
        return new EventTable[]{new PropertySortedEventTableImpl(this.propertyGetter, organization)};
    }

    @Override
    public Class getEventTableClass() {
        return PropertySortedEventTable.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyName=" + this.propertyName;
    }

    public int getStreamNum() {
        return this.streamNum;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public EventPropertyGetter getPropertyGetter() {
        return this.propertyGetter;
    }

    protected EventTableOrganization getOrganization() {
        return new EventTableOrganization(null, false, false, this.streamNum, new String[]{this.propertyName}, EventTableOrganizationType.BTREE);
    }
}

