/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.pollindex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdentStmt;
import com.espertech.esper.epl.join.table.PropertySortedEventTableCoercedFactory;
import com.espertech.esper.epl.join.table.PropertySortedEventTableFactory;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import java.util.List;

public class PollResultIndexingStrategySorted
implements PollResultIndexingStrategy {
    private final int streamNum;
    private final EventType eventType;
    private final String propertyName;
    private final Class coercionType;

    public PollResultIndexingStrategySorted(int streamNum, EventType eventType, String propertyName, Class coercionType) {
        this.streamNum = streamNum;
        this.eventType = eventType;
        this.propertyName = propertyName;
        this.coercionType = coercionType;
    }

    @Override
    public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache, StatementContext statementContext) {
        EventTable[] tables;
        if (!isActiveCache) {
            return new EventTable[]{new UnindexedEventTableList(pollResult, this.streamNum)};
        }
        PropertySortedEventTableFactory tableFactory = this.coercionType == null ? new PropertySortedEventTableFactory(this.streamNum, this.eventType, this.propertyName) : new PropertySortedEventTableCoercedFactory(this.streamNum, this.eventType, this.propertyName, this.coercionType);
        ExprEvaluatorContextStatement evaluatorContextStatement = new ExprEvaluatorContextStatement(statementContext, false);
        for (EventTable table : tables = tableFactory.makeEventTables(new EventTableFactoryTableIdentStmt(statementContext), evaluatorContextStatement)) {
            table.add(pollResult.toArray(new EventBean[pollResult.size()]), (ExprEvaluatorContext)evaluatorContextStatement);
        }
        return tables;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " property " + this.propertyName + " coercion " + this.coercionType;
    }
}

