/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.pollindex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdentStmt;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleFactory;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import java.util.Arrays;
import java.util.List;

public class PollResultIndexingStrategyIndexSingleArray
implements PollResultIndexingStrategy {
    private final int streamNum;
    private final EventType eventType;
    private final String[] propertyNames;

    public PollResultIndexingStrategyIndexSingleArray(int streamNum, EventType eventType, String[] propertyNames) {
        this.streamNum = streamNum;
        this.eventType = eventType;
        this.propertyNames = propertyNames;
    }

    @Override
    public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache, StatementContext statementContext) {
        if (!isActiveCache) {
            return new EventTable[]{new UnindexedEventTableList(pollResult, this.streamNum)};
        }
        EventTable[] tables = new EventTable[this.propertyNames.length];
        ExprEvaluatorContextStatement evaluatorContextStatement = new ExprEvaluatorContextStatement(statementContext, false);
        for (int i = 0; i < this.propertyNames.length; ++i) {
            PropertyIndexedEventTableSingleFactory factory = new PropertyIndexedEventTableSingleFactory(this.streamNum, this.eventType, this.propertyNames[i], false, null);
            tables[i] = factory.makeEventTables(new EventTableFactoryTableIdentStmt(statementContext), evaluatorContextStatement)[0];
            tables[i].add(pollResult.toArray(new EventBean[pollResult.size()]), (ExprEvaluatorContext)evaluatorContextStatement);
        }
        return tables;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " properties " + Arrays.toString(this.propertyNames);
    }
}

