/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.plan.TableLookupKeyDesc;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;

public abstract class TableLookupPlan {
    private int lookupStream;
    private int indexedStream;
    private TableLookupIndexReqKey[] indexNum;

    public abstract JoinExecTableLookupStrategy makeStrategyInternal(EventTable[] var1, EventType[] var2);

    public abstract TableLookupKeyDesc getKeyDescriptor();

    public final JoinExecTableLookupStrategy makeStrategy(String statementName, int statementId, Annotation[] accessedByStmtAnnotations, Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, EventType[] eventTypes, VirtualDWView[] viewExternals) {
        EventTable[] eventTables = new EventTable[this.indexNum.length];
        for (int i = 0; i < this.indexNum.length; ++i) {
            eventTables[i] = indexesPerStream[this.getIndexedStream()].get(this.getIndexNum()[i]);
        }
        if (viewExternals[this.indexedStream] != null) {
            return viewExternals[this.indexedStream].getJoinLookupStrategy(statementName, statementId, accessedByStmtAnnotations, eventTables, this.getKeyDescriptor(), this.lookupStream);
        }
        return this.makeStrategyInternal(eventTables, eventTypes);
    }

    protected TableLookupPlan(int lookupStream, int indexedStream, TableLookupIndexReqKey[] indexNum) {
        this.lookupStream = lookupStream;
        this.indexedStream = indexedStream;
        this.indexNum = indexNum;
    }

    public int getLookupStream() {
        return this.lookupStream;
    }

    public int getIndexedStream() {
        return this.indexedStream;
    }

    public TableLookupIndexReqKey[] getIndexNum() {
        return this.indexNum;
    }

    public String toString() {
        return "lookupStream=" + this.lookupStream + " indexedStream=" + this.indexedStream + " indexNum=" + Arrays.toString(this.indexNum);
    }
}

