/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.epl.index.service.EventAdvancedIndexProvisionDesc;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class QueryPlanIndexItem {
    private final String[] indexProps;
    private Class[] optIndexCoercionTypes;
    private final String[] rangeProps;
    private final Class[] optRangeCoercionTypes;
    private final boolean unique;
    private final EventAdvancedIndexProvisionDesc advancedIndexProvisionDesc;

    public QueryPlanIndexItem(String[] indexProps, Class[] optIndexCoercionTypes, String[] rangeProps, Class[] optRangeCoercionTypes, boolean unique, EventAdvancedIndexProvisionDesc advancedIndexProvisionDesc) {
        if (advancedIndexProvisionDesc == null) {
            if (unique && indexProps.length == 0) {
                throw new IllegalArgumentException("Invalid unique index planned without hash index props");
            }
            if (unique && rangeProps.length > 0) {
                throw new IllegalArgumentException("Invalid unique index planned that includes range props");
            }
        }
        this.indexProps = indexProps;
        this.optIndexCoercionTypes = optIndexCoercionTypes;
        this.rangeProps = rangeProps == null || rangeProps.length == 0 ? null : rangeProps;
        this.optRangeCoercionTypes = optRangeCoercionTypes;
        this.unique = unique;
        this.advancedIndexProvisionDesc = advancedIndexProvisionDesc;
    }

    public QueryPlanIndexItem(List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, boolean unique, EventAdvancedIndexProvisionDesc advancedIndexProvisionDesc) {
        this(QueryPlanIndexItem.getNames(hashProps), QueryPlanIndexItem.getTypes(hashProps), QueryPlanIndexItem.getNames(btreeProps), QueryPlanIndexItem.getTypes(btreeProps), unique, advancedIndexProvisionDesc);
    }

    public String[] getIndexProps() {
        return this.indexProps;
    }

    public Class[] getOptIndexCoercionTypes() {
        return this.optIndexCoercionTypes;
    }

    public String[] getRangeProps() {
        return this.rangeProps;
    }

    public Class[] getOptRangeCoercionTypes() {
        return this.optRangeCoercionTypes;
    }

    public void setOptIndexCoercionTypes(Class[] optIndexCoercionTypes) {
        this.optIndexCoercionTypes = optIndexCoercionTypes;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public EventAdvancedIndexProvisionDesc getAdvancedIndexProvisionDesc() {
        return this.advancedIndexProvisionDesc;
    }

    public String toString() {
        return "QueryPlanIndexItem{unique=" + this.unique + ", indexProps=" + (this.indexProps == null ? null : Arrays.asList(this.indexProps)) + ", rangeProps=" + (this.rangeProps == null ? null : Arrays.asList(this.rangeProps)) + ", optIndexCoercionTypes=" + (this.optIndexCoercionTypes == null ? null : Arrays.asList(this.optIndexCoercionTypes)) + ", optRangeCoercionTypes=" + (this.optRangeCoercionTypes == null ? null : Arrays.asList(this.optRangeCoercionTypes)) + ", advanced=" + (this.advancedIndexProvisionDesc == null ? null : this.advancedIndexProvisionDesc.getIndexDesc().getIndexTypeName()) + "}";
    }

    public boolean equalsCompareSortedProps(QueryPlanIndexItem other) {
        if (this.unique != other.unique) {
            return false;
        }
        String[] otherIndexProps = CollectionUtil.copySortArray(other.getIndexProps());
        String[] thisIndexProps = CollectionUtil.copySortArray(this.getIndexProps());
        String[] otherRangeProps = CollectionUtil.copySortArray(other.getRangeProps());
        String[] thisRangeProps = CollectionUtil.copySortArray(this.getRangeProps());
        boolean compared = CollectionUtil.compare(otherIndexProps, thisIndexProps) && CollectionUtil.compare(otherRangeProps, thisRangeProps);
        return compared && this.advancedIndexProvisionDesc == null && other.advancedIndexProvisionDesc == null;
    }

    public List<IndexedPropDesc> getHashPropsAsList() {
        return this.asList(this.indexProps, this.optIndexCoercionTypes);
    }

    public List<IndexedPropDesc> getBtreePropsAsList() {
        return this.asList(this.rangeProps, this.optRangeCoercionTypes);
    }

    private List<IndexedPropDesc> asList(String[] props, Class[] types) {
        if (props == null || props.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IndexedPropDesc> list = new ArrayList<IndexedPropDesc>(props.length);
        for (int i = 0; i < props.length; ++i) {
            list.add(new IndexedPropDesc(props[i], types[i]));
        }
        return list;
    }

    private static String[] getNames(IndexedPropDesc[] props) {
        String[] names = new String[props.length];
        for (int i = 0; i < props.length; ++i) {
            names[i] = props[i].getIndexPropName();
        }
        return names;
    }

    private static Class[] getTypes(IndexedPropDesc[] props) {
        Class[] types = new Class[props.length];
        for (int i = 0; i < props.length; ++i) {
            types[i] = props[i].getCoercionType();
        }
        return types;
    }

    private static String[] getNames(List<IndexedPropDesc> props) {
        String[] names = new String[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            names[i] = props.get(i).getIndexPropName();
        }
        return names;
    }

    private static Class[] getTypes(List<IndexedPropDesc> props) {
        Class[] types = new Class[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            types[i] = props.get(i).getCoercionType();
        }
        return types;
    }

    public static QueryPlanIndexItem fromIndexMultikeyTablePrimaryKey(IndexMultiKey indexMultiKey) {
        return new QueryPlanIndexItem(QueryPlanIndexItem.getNames(indexMultiKey.getHashIndexedProps()), QueryPlanIndexItem.getTypes(indexMultiKey.getHashIndexedProps()), QueryPlanIndexItem.getNames(indexMultiKey.getRangeIndexedProps()), QueryPlanIndexItem.getTypes(indexMultiKey.getRangeIndexedProps()), indexMultiKey.isUnique(), null);
    }
}

