/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.plan.NStreamOuterQueryPlanBuilder;
import com.espertech.esper.epl.join.plan.NStreamQueryPlanBuilder;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanNodeAllUnidirectionalOuter;
import com.espertech.esper.epl.join.plan.QueryPlanNodeNoOp;
import com.espertech.esper.epl.join.plan.TwoStreamQueryPlanBuilder;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.util.DependencyGraph;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPlanBuilder {
    private static final Logger QUERY_PLAN_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.queryplan");
    private static final Logger log = LoggerFactory.getLogger(QueryPlanBuilder.class);

    public static QueryPlan getPlan(EventType[] typesPerStream, OuterJoinDesc[] outerJoinDescList, QueryGraph queryGraph, String[] streamNames, HistoricalViewableDesc historicalViewableDesc, DependencyGraph dependencyGraph, HistoricalStreamIndexList[] historicalStreamIndexLists, StreamJoinAnalysisResult streamJoinAnalysisResult, boolean isQueryPlanLogging, Annotation[] annotations, ExprEvaluatorContext exprEvaluatorContext, EngineImportService engineImportService, boolean isFireAndForget) throws ExprValidationException {
        QueryPlan queryPlan;
        boolean isAllInnerJoins;
        String methodName = ".getPlan ";
        int numStreams = typesPerStream.length;
        if (numStreams < 2) {
            throw new IllegalArgumentException("Number of join stream types is less then 2");
        }
        if (outerJoinDescList.length >= numStreams) {
            throw new IllegalArgumentException("Too many outer join descriptors found");
        }
        if (numStreams == 2) {
            OuterJoinType outerJoinType = null;
            if (outerJoinDescList.length > 0) {
                outerJoinType = outerJoinDescList[0].getOuterJoinType();
            }
            QueryPlan queryPlan2 = TwoStreamQueryPlanBuilder.build(typesPerStream, queryGraph, outerJoinType, streamJoinAnalysisResult.getUniqueKeys(), streamJoinAnalysisResult.getTablesPerStream());
            QueryPlanBuilder.removeUnidirectionalAndTable(queryPlan2, streamJoinAnalysisResult);
            if (log.isDebugEnabled()) {
                log.debug(methodName + "2-Stream queryPlan=" + queryPlan2);
            }
            return queryPlan2;
        }
        boolean hasPreferMergeJoin = HintEnum.PREFER_MERGE_JOIN.getHint(annotations) != null;
        boolean hasForceNestedIter = HintEnum.FORCE_NESTED_ITER.getHint(annotations) != null;
        boolean bl = isAllInnerJoins = outerJoinDescList.length == 0 || OuterJoinDesc.consistsOfAllInnerJoins(outerJoinDescList);
        if (isAllInnerJoins && !hasPreferMergeJoin) {
            queryPlan = NStreamQueryPlanBuilder.build(queryGraph, typesPerStream, historicalViewableDesc, dependencyGraph, historicalStreamIndexLists, hasForceNestedIter, streamJoinAnalysisResult.getUniqueKeys(), streamJoinAnalysisResult.getTablesPerStream());
            if (queryPlan != null) {
                QueryPlanBuilder.removeUnidirectionalAndTable(queryPlan, streamJoinAnalysisResult);
                if (log.isDebugEnabled()) {
                    log.debug(methodName + "N-Stream inner-join queryPlan=" + queryPlan);
                }
                return queryPlan;
            }
            if (isQueryPlanLogging && QUERY_PLAN_LOG.isInfoEnabled()) {
                log.info("Switching to Outer-NStream algorithm for query plan");
            }
        }
        queryPlan = NStreamOuterQueryPlanBuilder.build(queryGraph, outerJoinDescList, streamNames, typesPerStream, historicalViewableDesc, dependencyGraph, historicalStreamIndexLists, exprEvaluatorContext, streamJoinAnalysisResult.getUniqueKeys(), streamJoinAnalysisResult.getTablesPerStream(), engineImportService, isFireAndForget);
        QueryPlanBuilder.removeUnidirectionalAndTable(queryPlan, streamJoinAnalysisResult);
        return queryPlan;
    }

    private static void removeUnidirectionalAndTable(QueryPlan queryPlan, StreamJoinAnalysisResult streamJoinAnalysisResult) {
        boolean allUnidirectional = streamJoinAnalysisResult.isUnidirectionalAll();
        for (int streamNum = 0; streamNum < queryPlan.getExecNodeSpecs().length; ++streamNum) {
            boolean table;
            if (allUnidirectional) {
                queryPlan.getExecNodeSpecs()[streamNum] = new QueryPlanNodeAllUnidirectionalOuter(streamNum);
                continue;
            }
            boolean unidirectional = streamJoinAnalysisResult.isUnidirectional() && !streamJoinAnalysisResult.getUnidirectionalInd()[streamNum];
            boolean bl = table = streamJoinAnalysisResult.getTablesPerStream()[streamNum] != null;
            if (!unidirectional && !table) continue;
            queryPlan.getExecNodeSpecs()[streamNum] = new QueryPlanNodeNoOp();
        }
    }
}

