/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNodeFactory;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.exec.base.LookupInstructionExec;
import com.espertech.esper.epl.join.exec.base.LookupInstructionExecNode;
import com.espertech.esper.epl.join.plan.LookupInstructionPlan;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.util.IndentWriter;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class LookupInstructionQueryPlanNode
extends QueryPlanNode {
    private final int rootStream;
    private final String rootStreamName;
    private final int numStreams;
    private final List<LookupInstructionPlan> lookupInstructions;
    private final boolean[] requiredPerStream;
    private final List<BaseAssemblyNodeFactory> assemblyInstructionFactories;

    public LookupInstructionQueryPlanNode(int rootStream, String rootStreamName, int numStreams, boolean[] requiredPerStream, List<LookupInstructionPlan> lookupInstructions, List<BaseAssemblyNodeFactory> assemblyInstructionFactories) {
        this.rootStream = rootStream;
        this.rootStreamName = rootStreamName;
        this.lookupInstructions = lookupInstructions;
        this.numStreams = numStreams;
        this.requiredPerStream = requiredPerStream;
        this.assemblyInstructionFactories = assemblyInstructionFactories;
    }

    @Override
    public ExecNode makeExec(String statementName, int statementId, Annotation[] annotations, Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, EventType[] streamTypes, Viewable[] streamViews, HistoricalStreamIndexList[] historicalStreamIndexLists, VirtualDWView[] viewExternal, Lock[] tableSecondaryIndexLocks) {
        LookupInstructionExec[] execs = new LookupInstructionExec[this.lookupInstructions.size()];
        int count = 0;
        for (LookupInstructionPlan instruction : this.lookupInstructions) {
            LookupInstructionExec exec;
            execs[count] = exec = instruction.makeExec(statementName, statementId, annotations, indexesPerStream, streamTypes, streamViews, historicalStreamIndexLists, viewExternal);
            ++count;
        }
        return new LookupInstructionExecNode(this.rootStream, this.rootStreamName, this.numStreams, execs, this.requiredPerStream, this.assemblyInstructionFactories);
    }

    @Override
    public void addIndexes(HashSet<TableLookupIndexReqKey> usedIndexes) {
        for (LookupInstructionPlan plan : this.lookupInstructions) {
            plan.addIndexes(usedIndexes);
        }
    }

    @Override
    protected void print(IndentWriter writer) {
        int i;
        writer.println("LookupInstructionQueryPlanNode rootStream=" + this.rootStream + " requiredPerStream=" + Arrays.toString(this.requiredPerStream));
        writer.incrIndent();
        for (i = 0; i < this.lookupInstructions.size(); ++i) {
            writer.println("lookup step " + i);
            writer.incrIndent();
            this.lookupInstructions.get(i).print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
        writer.incrIndent();
        for (i = 0; i < this.assemblyInstructionFactories.size(); ++i) {
            writer.println("assembly step " + i);
            writer.incrIndent();
            this.assemblyInstructionFactories.get(i).print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
    }

    public int getRootStream() {
        return this.rootStream;
    }

    public String getRootStreamName() {
        return this.rootStreamName;
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public List<LookupInstructionPlan> getLookupInstructions() {
        return this.lookupInstructions;
    }

    public boolean[] getRequiredPerStream() {
        return this.requiredPerStream;
    }

    public List<BaseAssemblyNodeFactory> getAssemblyInstructionFactories() {
        return this.assemblyInstructionFactories;
    }
}

