/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.hint;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.epl.join.hint.IndexHintInstruction;
import com.espertech.esper.epl.join.hint.IndexHintInstructionBust;
import com.espertech.esper.epl.join.hint.IndexHintInstructionExplicit;
import com.espertech.esper.epl.join.hint.IndexHintInstructionIndexName;
import com.espertech.esper.epl.join.hint.IndexHintSelector;
import com.espertech.esper.epl.join.hint.IndexHintSelectorSubquery;
import com.espertech.esper.epl.join.hint.SelectorInstructionPair;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class IndexHint {
    private final List<SelectorInstructionPair> pairs;

    public IndexHint(List<SelectorInstructionPair> pairs) {
        this.pairs = pairs;
    }

    public static IndexHint getIndexHint(Annotation[] annotations) {
        List<String> hints = HintEnum.INDEX.getHintAssignedValues(annotations);
        if (hints == null) {
            return null;
        }
        ArrayList<SelectorInstructionPair> pairs = new ArrayList<SelectorInstructionPair>();
        for (String hint : hints) {
            String[] hintAtoms = HintEnum.splitCommaUnlessInParen(hint);
            ArrayList<IndexHintSelector> selectors = new ArrayList<IndexHintSelector>();
            ArrayList<IndexHintInstruction> instructions = new ArrayList<IndexHintInstruction>();
            for (int i = 0; i < hintAtoms.length; ++i) {
                String hintAtom = hintAtoms[i];
                if (hintAtom.toLowerCase(Locale.ENGLISH).trim().equals("bust")) {
                    instructions.add(new IndexHintInstructionBust());
                    continue;
                }
                if (hintAtom.toLowerCase(Locale.ENGLISH).trim().equals("explicit")) {
                    instructions.add(new IndexHintInstructionExplicit());
                    continue;
                }
                if (IndexHint.checkValueInParen("subquery", hintAtom.toLowerCase(Locale.ENGLISH))) {
                    int subqueryNum = IndexHint.extractValueParen(hintAtom);
                    selectors.add(new IndexHintSelectorSubquery(subqueryNum));
                    continue;
                }
                instructions.add(new IndexHintInstructionIndexName(hintAtom.trim()));
            }
            pairs.add(new SelectorInstructionPair(selectors, instructions));
        }
        return new IndexHint(pairs);
    }

    public List<IndexHintInstruction> getInstructionsSubquery(int subqueryNumber) {
        for (SelectorInstructionPair pair : this.pairs) {
            if (pair.getSelector().isEmpty()) {
                return pair.getInstructions();
            }
            for (IndexHintSelector selector : pair.getSelector()) {
                if (!selector.matchesSubquery(subqueryNumber)) continue;
                return pair.getInstructions();
            }
        }
        return Collections.emptyList();
    }

    public List<IndexHintInstruction> getInstructionsFireAndForget() {
        for (SelectorInstructionPair pair : this.pairs) {
            if (!pair.getSelector().isEmpty()) continue;
            return pair.getInstructions();
        }
        return Collections.emptyList();
    }

    protected static boolean checkValueInParen(String type, String value) {
        String noparen;
        int indexOpen = value.indexOf(40);
        return indexOpen != -1 && type.equals(noparen = value.substring(0, indexOpen).trim().toLowerCase(Locale.ENGLISH));
    }

    protected static boolean checkValueAssignment(String type, String value) {
        String noequals;
        int indexEquals = value.indexOf(61);
        return indexEquals != -1 && type.equals(noequals = value.substring(0, indexEquals).trim().toLowerCase(Locale.ENGLISH));
    }

    protected static int extractValueParen(String text) {
        int indexOpen = text.indexOf(40);
        int indexClosed = text.lastIndexOf(41);
        if (indexOpen != -1) {
            String value = text.substring(indexOpen + 1, indexClosed).trim();
            try {
                return Integer.parseInt(value);
            }
            catch (Exception ex) {
                throw new EPException("Failed to parse '" + value + "' as an index hint integer value");
            }
        }
        throw new IllegalStateException("Not a parentheses value");
    }

    protected static Object extractValueEqualsStringOrInt(String text) {
        String value = IndexHint.extractValueEquals(text);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            return value;
        }
    }

    protected static String extractValueEquals(String text) {
        int indexEquals = text.indexOf(61);
        if (indexEquals != -1) {
            return text.substring(indexEquals + 1).trim();
        }
        throw new IllegalStateException("Not a parentheses value");
    }
}

