/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.composite;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValue;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueEquals;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueRange;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexLookup;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexQueryResultPostProcessor;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.filterspec.Range;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class CompositeIndexLookupRange
implements CompositeIndexLookup {
    private final RangeIndexLookupValue lookupValue;
    private final Class coercionType;
    private CompositeIndexLookup next;

    public CompositeIndexLookupRange(RangeIndexLookupValue lookupValue, Class coercionType) {
        this.lookupValue = lookupValue;
        this.coercionType = coercionType;
    }

    @Override
    public void lookup(Map parent, Set<EventBean> result, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (this.lookupValue instanceof RangeIndexLookupValueEquals) {
            RangeIndexLookupValueEquals equals = (RangeIndexLookupValueEquals)this.lookupValue;
            Object inner = parent.get(equals.getValue());
            if (this.next == null) {
                result.addAll((Set)inner);
            } else {
                Map innerMap = (Map)inner;
                this.next.lookup(innerMap, result, postProcessor);
            }
            return;
        }
        RangeIndexLookupValueRange lookup = (RangeIndexLookupValueRange)this.lookupValue;
        TreeMap treeMap = (TreeMap)parent;
        Object rangeValue = lookup.getValue();
        if (lookup.getOperator() == QueryGraphRangeEnum.RANGE_CLOSED) {
            Range range = (Range)rangeValue;
            this.lookupRange(result, treeMap, range.getLowEndpoint(), true, range.getHighEndpoint(), true, true, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.RANGE_HALF_OPEN) {
            Range range = (Range)rangeValue;
            this.lookupRange(result, treeMap, range.getLowEndpoint(), true, range.getHighEndpoint(), false, true, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.RANGE_HALF_CLOSED) {
            Range range = (Range)rangeValue;
            this.lookupRange(result, treeMap, range.getLowEndpoint(), false, range.getHighEndpoint(), true, true, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.RANGE_OPEN) {
            Range range = (Range)rangeValue;
            this.lookupRange(result, treeMap, range.getLowEndpoint(), false, range.getHighEndpoint(), false, true, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.NOT_RANGE_CLOSED) {
            Range range = (Range)rangeValue;
            this.lookupRangeInverted(result, treeMap, range.getLowEndpoint(), true, range.getHighEndpoint(), true, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.NOT_RANGE_HALF_OPEN) {
            Range range = (Range)rangeValue;
            this.lookupRangeInverted(result, treeMap, range.getLowEndpoint(), true, range.getHighEndpoint(), false, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.NOT_RANGE_HALF_CLOSED) {
            Range range = (Range)rangeValue;
            this.lookupRangeInverted(result, treeMap, range.getLowEndpoint(), false, range.getHighEndpoint(), true, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.NOT_RANGE_OPEN) {
            Range range = (Range)rangeValue;
            this.lookupRangeInverted(result, treeMap, range.getLowEndpoint(), false, range.getHighEndpoint(), false, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.GREATER) {
            this.lookupGreater(result, treeMap, rangeValue, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.GREATER_OR_EQUAL) {
            this.lookupGreaterEqual(result, treeMap, rangeValue, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.LESS) {
            this.lookupLess(result, treeMap, rangeValue, postProcessor);
        } else if (lookup.getOperator() == QueryGraphRangeEnum.LESS_OR_EQUAL) {
            this.lookupLessEqual(result, treeMap, rangeValue, postProcessor);
        } else {
            throw new IllegalArgumentException("Unrecognized operator '" + (Object)((Object)lookup.getOperator()) + "'");
        }
    }

    public void lookupRange(Set<EventBean> result, TreeMap propertyIndex, Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd, boolean allowRangeReversal, CompositeIndexQueryResultPostProcessor postProcessor) {
        NavigableMap<Object, Object> submap;
        if (keyStart == null || keyEnd == null) {
            return;
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        try {
            submap = propertyIndex.subMap(keyStart, includeStart, keyEnd, includeEnd);
        }
        catch (IllegalArgumentException ex) {
            if (allowRangeReversal) {
                submap = propertyIndex.subMap(keyEnd, includeStart, keyStart, includeEnd);
            }
            return;
        }
        this.normalize(result, submap, postProcessor);
    }

    public void lookupRangeInverted(Set<EventBean> result, TreeMap propertyIndex, Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (keyStart == null || keyEnd == null) {
            return;
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        NavigableMap<Object, Object> submapOne = propertyIndex.headMap(keyStart, !includeStart);
        NavigableMap<Object, Object> submapTwo = propertyIndex.tailMap(keyEnd, !includeEnd);
        this.normalize(result, submapOne, submapTwo, postProcessor);
    }

    public void lookupLess(Set<EventBean> result, TreeMap propertyIndex, Object keyStart, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (keyStart == null) {
            return;
        }
        keyStart = this.coerce(keyStart);
        this.normalize(result, propertyIndex.headMap(keyStart), postProcessor);
    }

    public void lookupLessEqual(Set<EventBean> result, TreeMap propertyIndex, Object keyStart, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (keyStart == null) {
            return;
        }
        keyStart = this.coerce(keyStart);
        this.normalize(result, propertyIndex.headMap(keyStart, true), postProcessor);
    }

    public void lookupGreaterEqual(Set<EventBean> result, TreeMap propertyIndex, Object keyStart, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (keyStart == null) {
            return;
        }
        keyStart = this.coerce(keyStart);
        this.normalize(result, propertyIndex.tailMap(keyStart), postProcessor);
    }

    public void lookupGreater(Set<EventBean> result, TreeMap propertyIndex, Object keyStart, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (keyStart == null) {
            return;
        }
        keyStart = this.coerce(keyStart);
        this.normalize(result, propertyIndex.tailMap(keyStart, false), postProcessor);
    }

    private Object coerce(Object key) {
        return EventBeanUtility.coerce(key, this.coercionType);
    }

    private void normalize(Set<EventBean> result, Map<Object, Object> submap, CompositeIndexQueryResultPostProcessor postProcessor) {
        if (submap.size() == 0) {
            return;
        }
        if (this.next == null) {
            if (postProcessor != null) {
                for (Map.Entry<Object, Object> entry : submap.entrySet()) {
                    postProcessor.add(entry.getValue(), result);
                }
            } else {
                for (Map.Entry<Object, Object> entry : submap.entrySet()) {
                    Set set = (Set)entry.getValue();
                    result.addAll(set);
                }
            }
        } else {
            for (Map.Entry<Object, Object> entry : submap.entrySet()) {
                TreeMap index = (TreeMap)entry.getValue();
                this.next.lookup(index, result, postProcessor);
            }
        }
    }

    private void normalize(Set<EventBean> result, SortedMap<Object, Object> submapOne, SortedMap<Object, Object> submapTwo, CompositeIndexQueryResultPostProcessor postProcessor) {
        this.normalize(result, submapTwo, postProcessor);
        this.normalize(result, submapOne, postProcessor);
    }

    @Override
    public void setNext(CompositeIndexLookup next) {
        this.next = next;
    }
}

