/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.composite;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;

public abstract class CompositeAccessStrategyRangeBase {
    protected final ExprEvaluator start;
    protected final boolean includeStart;
    protected final ExprEvaluator end;
    protected final boolean includeEnd;
    private final EventBean[] events;
    private final int lookupStream;
    protected final Class coercionType;
    private final boolean isNWOnTrigger;

    protected CompositeAccessStrategyRangeBase(boolean isNWOnTrigger, int lookupStream, int numStreams, ExprEvaluator start, boolean includeStart, ExprEvaluator end, boolean includeEnd, Class coercionType) {
        this.start = start;
        this.includeStart = includeStart;
        this.end = end;
        this.includeEnd = includeEnd;
        this.coercionType = coercionType;
        this.isNWOnTrigger = isNWOnTrigger;
        this.events = lookupStream != -1 ? new EventBean[lookupStream + 1] : new EventBean[numStreams + 1];
        this.lookupStream = lookupStream;
    }

    public Object evaluateLookupStart(EventBean theEvent, ExprEvaluatorContext context) {
        this.events[this.lookupStream] = theEvent;
        return this.start.evaluate(this.events, true, context);
    }

    public Object evaluateLookupEnd(EventBean theEvent, ExprEvaluatorContext context) {
        this.events[this.lookupStream] = theEvent;
        return this.end.evaluate(this.events, true, context);
    }

    public Object evaluatePerStreamStart(EventBean[] eventPerStream, ExprEvaluatorContext context) {
        if (this.isNWOnTrigger) {
            return this.start.evaluate(eventPerStream, true, context);
        }
        System.arraycopy(eventPerStream, 0, this.events, 1, eventPerStream.length);
        return this.start.evaluate(this.events, true, context);
    }

    public Object evaluatePerStreamEnd(EventBean[] eventPerStream, ExprEvaluatorContext context) {
        if (this.isNWOnTrigger) {
            return this.end.evaluate(eventPerStream, true, context);
        }
        System.arraycopy(eventPerStream, 0, this.events, 1, eventPerStream.length);
        return this.end.evaluate(this.events, true, context);
    }
}

