/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.HistoricalDataQueryStrategy;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategyNoIndex;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerHistoricalImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.QueryStrategy;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyNoIndex;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;

public class JoinSetComposerPrototypeHistorical2StreamImpl
implements JoinSetComposerPrototype {
    private final ExprEvaluator optionalFilterEval;
    private final EventType[] streamTypes;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final int polledViewNum;
    private final int streamViewNum;
    private final boolean isOuterJoin;
    private final ExprEvaluator outerJoinEqualsEval;
    private final Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> indexStrategies;
    private final boolean isAllHistoricalNoSubordinate;
    private final OuterJoinDesc[] outerJoinDescList;
    private final boolean allowIndexInit;

    public JoinSetComposerPrototypeHistorical2StreamImpl(ExprEvaluator optionalFilterEval, EventType[] streamTypes, ExprEvaluatorContext exprEvaluatorContext, int polledViewNum, int streamViewNum, boolean outerJoin, ExprEvaluator outerJoinEqualsEval, Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> indexStrategies, boolean allHistoricalNoSubordinate, OuterJoinDesc[] outerJoinDescList, boolean allowIndexInit) {
        this.optionalFilterEval = optionalFilterEval;
        this.streamTypes = streamTypes;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.polledViewNum = polledViewNum;
        this.streamViewNum = streamViewNum;
        this.isOuterJoin = outerJoin;
        this.outerJoinEqualsEval = outerJoinEqualsEval;
        this.indexStrategies = indexStrategies;
        this.isAllHistoricalNoSubordinate = allHistoricalNoSubordinate;
        this.outerJoinDescList = outerJoinDescList;
        this.allowIndexInit = allowIndexInit;
    }

    @Override
    public JoinSetComposerDesc create(Viewable[] streamViews, boolean isFireAndForget, AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        QueryStrategy[] queryStrategies = new QueryStrategy[this.streamTypes.length];
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[this.polledViewNum];
        queryStrategies[this.streamViewNum] = new HistoricalDataQueryStrategy(this.streamViewNum, this.polledViewNum, viewable, this.isOuterJoin, this.outerJoinEqualsEval, this.indexStrategies.getFirst(), this.indexStrategies.getSecond());
        if (this.isAllHistoricalNoSubordinate) {
            boolean isOuterJoin = false;
            if (this.outerJoinDescList.length > 0) {
                OuterJoinDesc outerJoinDesc = this.outerJoinDescList[0];
                if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.FULL)) {
                    isOuterJoin = true;
                } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.LEFT) && this.polledViewNum == 0) {
                    isOuterJoin = true;
                } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.RIGHT) && this.polledViewNum == 1) {
                    isOuterJoin = true;
                }
            }
            viewable = (HistoricalEventViewable)streamViews[this.streamViewNum];
            queryStrategies[this.polledViewNum] = new HistoricalDataQueryStrategy(this.polledViewNum, this.streamViewNum, viewable, isOuterJoin, this.outerJoinEqualsEval, new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        JoinSetComposerHistoricalImpl composer = new JoinSetComposerHistoricalImpl(this.allowIndexInit, null, queryStrategies, streamViews, this.exprEvaluatorContext);
        return new JoinSetComposerDesc(composer, this.optionalFilterEval);
    }
}

