/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import java.util.Iterator;
import java.util.Set;

public class HistoricalIndexLookupStrategyIndexSingle
implements HistoricalIndexLookupStrategy {
    private final EventBean[] eventsPerStream;
    private final ExprEvaluator evaluator;
    private final int lookupStream;

    public HistoricalIndexLookupStrategyIndexSingle(int lookupStream, QueryGraphValueEntryHashKeyed hashKey) {
        this.eventsPerStream = new EventBean[lookupStream + 1];
        this.evaluator = hashKey.getKeyExpr().getForge().getExprEvaluator();
        this.lookupStream = lookupStream;
    }

    @Override
    public Iterator<EventBean> lookup(EventBean lookupEvent, EventTable[] indexTable, ExprEvaluatorContext exprEvaluatorContext) {
        if (indexTable[0] instanceof PropertyIndexedEventTableSingle) {
            PropertyIndexedEventTableSingle index = (PropertyIndexedEventTableSingle)indexTable[0];
            this.eventsPerStream[this.lookupStream] = lookupEvent;
            Object key = this.evaluator.evaluate(this.eventsPerStream, true, exprEvaluatorContext);
            Set<EventBean> events = index.lookup(key);
            if (events != null) {
                return events.iterator();
            }
            return null;
        }
        return indexTable[0].iterator();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " evaluator " + this.evaluator.getClass().getSimpleName();
    }
}

