/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.assemble;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.epl.join.rep.Node;
import com.espertech.esper.util.IndentWriter;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class LeafAssemblyNode
extends BaseAssemblyNode {
    public LeafAssemblyNode(int streamNum, int numStreams) {
        super(streamNum, numStreams);
    }

    @Override
    public void init(List<Node>[] result) {
    }

    @Override
    public void process(List<Node>[] result, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        List<Node> nodes = result[this.streamNum];
        if (nodes == null) {
            return;
        }
        for (Node node : nodes) {
            Set<EventBean> events = node.getEvents();
            for (EventBean theEvent : events) {
                this.processEvent(theEvent, node, resultFinalRows, resultRootEvent);
            }
        }
    }

    private void processEvent(EventBean theEvent, Node currentNode, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        EventBean[] row = new EventBean[this.numStreams];
        row[this.streamNum] = theEvent;
        this.parentNode.result(row, this.streamNum, currentNode.getParentEvent(), currentNode.getParent(), resultFinalRows, resultRootEvent);
    }

    @Override
    public void result(EventBean[] row, int streamNum, EventBean myEvent, Node myNode, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        throw new UnsupportedOperationException("Leaf node cannot process child results");
    }

    @Override
    public void print(IndentWriter indentWriter) {
        indentWriter.println("LeafAssemblyNode streamNum=" + this.streamNum);
    }
}

