/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.index.service;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.index.service.EventAdvancedIndexProvisionDesc;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdent;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.EventTableOrganizationType;
import com.espertech.esper.epl.lookup.AdvancedIndexConfigContextPartition;

public class EventTableFactoryCustomIndex
implements EventTableFactory {
    protected final EventType eventType;
    protected final EventAdvancedIndexProvisionDesc advancedIndexProvisionDesc;
    protected final EventTableOrganization organization;

    public EventTableFactoryCustomIndex(String indexName, int indexedStreamNum, EventType eventType, boolean unique, EventAdvancedIndexProvisionDesc advancedIndexProvisionDesc) {
        this.eventType = eventType;
        this.advancedIndexProvisionDesc = advancedIndexProvisionDesc;
        String[] expressions = ExprNodeUtilityCore.toExpressionStringMinPrecedenceAsArray(advancedIndexProvisionDesc.getIndexDesc().getIndexedExpressions());
        this.organization = new EventTableOrganization(indexName, unique, false, indexedStreamNum, expressions, EventTableOrganizationType.APPLICATION);
    }

    @Override
    public Class getEventTableClass() {
        return EventTable.class;
    }

    @Override
    public EventTable[] makeEventTables(EventTableFactoryTableIdent tableIdent, ExprEvaluatorContext exprEvaluatorContext) {
        AdvancedIndexConfigContextPartition configCP = this.advancedIndexProvisionDesc.getFactory().configureContextPartition(this.eventType, this.advancedIndexProvisionDesc.getIndexDesc(), this.advancedIndexProvisionDesc.getParameters(), exprEvaluatorContext, this.organization, this.advancedIndexProvisionDesc.getConfigStatement());
        EventTable eventTable = this.advancedIndexProvisionDesc.getFactory().make(this.advancedIndexProvisionDesc.getConfigStatement(), configCP, this.organization);
        return new EventTable[]{eventTable};
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.organization.getStreamNum() + " indexName=" + this.organization.getIndexName();
    }
}

