/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.visitor;

import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprVariableNode;
import com.espertech.esper.epl.expression.dot.ExprDotNode;
import com.espertech.esper.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.epl.variable.VariableService;
import java.util.HashSet;
import java.util.Set;

public class ExprNodeVariableVisitor
implements ExprNodeVisitor {
    private final VariableService variableService;
    private Set<String> variableNames;

    public ExprNodeVariableVisitor(VariableService variableService) {
        this.variableService = variableService;
    }

    @Override
    public boolean isVisit(ExprNode exprNode) {
        return true;
    }

    public boolean isHasVariables() {
        return this.variableNames != null && !this.variableNames.isEmpty();
    }

    @Override
    public void visit(ExprNode exprNode) {
        ExprDotNode exprDotNode;
        String variableName;
        if (exprNode instanceof ExprDotNode && (variableName = (exprDotNode = (ExprDotNode)exprNode).isVariableOpGetName(this.variableService)) != null) {
            this.addVariableName(variableName);
        }
        if (exprNode instanceof ExprVariableNode) {
            ExprVariableNode variableNode = (ExprVariableNode)exprNode;
            this.addVariableName(variableNode.getVariableName());
        }
    }

    public Set<String> getVariableNames() {
        return this.variableNames;
    }

    private void addVariableName(String name) {
        if (this.variableNames == null) {
            this.variableNames = new HashSet<String>();
        }
        this.variableNames.add(name);
    }
}

