/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Calendar;
import java.util.Date;

public class TimeAbacusMilliseconds
implements TimeAbacus {
    public static final TimeAbacusMilliseconds INSTANCE = new TimeAbacusMilliseconds();
    private static final long serialVersionUID = 7634550048792013972L;

    private TimeAbacusMilliseconds() {
    }

    @Override
    public long deltaForSecondsDouble(double seconds) {
        return Math.round(1000.0 * seconds);
    }

    @Override
    public CodegenExpression deltaForSecondsDoubleCodegen(CodegenExpressionRef sec, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(Math.class, "round", CodegenExpressionBuilder.op(CodegenExpressionBuilder.constant(1000.0), "*", sec));
    }

    @Override
    public long deltaForSecondsNumber(Number timeInSeconds) {
        if (JavaClassHelper.isFloatingPointNumber(timeInSeconds)) {
            return this.deltaForSecondsDouble(timeInSeconds.doubleValue());
        }
        return 1000L * timeInSeconds.longValue();
    }

    @Override
    public long calendarSet(long fromTime, Calendar cal) {
        cal.setTimeInMillis(fromTime);
        return 0L;
    }

    @Override
    public CodegenExpression calendarSetCodegen(CodegenExpression startLong, CodegenExpression cal, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethodBuild(codegenMethodScope.makeChild(Long.TYPE, TimeAbacusMilliseconds.class, codegenClassScope).addParam(Long.TYPE, "fromTime").addParam(Calendar.class, "cal").getBlock().expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.ref("fromTime"))).methodReturn(CodegenExpressionBuilder.constant(0))).pass(startLong).pass(cal).call();
    }

    @Override
    public long calendarGet(Calendar cal, long remainder) {
        return cal.getTimeInMillis();
    }

    @Override
    public long getOneSecond() {
        return 1000L;
    }

    @Override
    public Date toDate(long ts) {
        return new Date(ts);
    }

    @Override
    public CodegenExpression toDateCodegen(CodegenExpression ts) {
        return CodegenExpressionBuilder.newInstance(Date.class, ts);
    }

    @Override
    public CodegenExpression calendarGetCodegen(CodegenExpression cal, CodegenExpression startRemainder, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(cal, "getTimeInMillis", new CodegenExpression[0]);
    }
}

