/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprVariableNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodAdder;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodForge;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.TimeZone;

public class ExprTimePeriodImpl
extends ExprNodeBase
implements ExprTimePeriod {
    private static final long serialVersionUID = -7229827032500659319L;
    private final TimeZone timeZone;
    private final boolean hasYear;
    private final boolean hasMonth;
    private final boolean hasWeek;
    private final boolean hasDay;
    private final boolean hasHour;
    private final boolean hasMinute;
    private final boolean hasSecond;
    private final boolean hasMillisecond;
    private final boolean hasMicrosecond;
    private final TimeAbacus timeAbacus;
    private transient ExprTimePeriodForge forge;

    public ExprTimePeriodImpl(TimeZone timeZone, boolean hasYear, boolean hasMonth, boolean hasWeek, boolean hasDay, boolean hasHour, boolean hasMinute, boolean hasSecond, boolean hasMillisecond, boolean hasMicrosecond, TimeAbacus timeAbacus) {
        this.timeZone = timeZone;
        this.hasYear = hasYear;
        this.hasMonth = hasMonth;
        this.hasWeek = hasWeek;
        this.hasDay = hasDay;
        this.hasHour = hasHour;
        this.hasMinute = hasMinute;
        this.hasSecond = hasSecond;
        this.hasMillisecond = hasMillisecond;
        this.hasMicrosecond = hasMicrosecond;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public ExprForge getForge() {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprTimePeriodEvalDeltaConst constEvaluator(ExprEvaluatorContext context) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.constEvaluator(context);
    }

    @Override
    public ExprTimePeriodEvalDeltaNonConst nonconstEvaluator() {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.nonconstEvaluator();
    }

    @Override
    public CodegenExpression evaluateGetTimePeriodCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.evaluateGetTimePeriodCodegen(codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateAsSecondsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.evaluateAsSecondsCodegen(codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public boolean hasVariable() {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.isHasVariable();
    }

    @Override
    public TimePeriod evaluateGetTimePeriod(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.evaluateGetTimePeriod(eventsPerStream, newData, context);
    }

    @Override
    public double evaluateAsSeconds(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.evaluateAsSeconds(eventsPerStream, newData, context);
    }

    public TimeAbacus getTimeAbacus() {
        return this.timeAbacus;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public boolean isHasDay() {
        return this.hasDay;
    }

    @Override
    public boolean isHasHour() {
        return this.hasHour;
    }

    @Override
    public boolean isHasMinute() {
        return this.hasMinute;
    }

    @Override
    public boolean isHasSecond() {
        return this.hasSecond;
    }

    @Override
    public boolean isHasMillisecond() {
        return this.hasMillisecond;
    }

    @Override
    public boolean isHasMicrosecond() {
        return this.hasMicrosecond;
    }

    @Override
    public boolean isHasYear() {
        return this.hasYear;
    }

    @Override
    public boolean isHasMonth() {
        return this.hasMonth;
    }

    @Override
    public boolean isHasWeek() {
        return this.hasWeek;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        boolean hasVariables = false;
        for (ExprNode childNode : this.getChildNodes()) {
            hasVariables |= this.validate(childNode);
        }
        ArrayDeque<ExprTimePeriodAdder.TimePeriodAdder> list = new ArrayDeque<ExprTimePeriodAdder.TimePeriodAdder>();
        if (this.hasYear) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderYear());
        }
        if (this.hasMonth) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderMonth());
        }
        if (this.hasWeek) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderWeek());
        }
        if (this.hasDay) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderDay());
        }
        if (this.hasHour) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderHour());
        }
        if (this.hasMinute) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderMinute());
        }
        if (this.hasSecond) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderSecond());
        }
        if (this.hasMillisecond) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderMSec());
        }
        if (this.hasMicrosecond) {
            list.add(new ExprTimePeriodAdder.TimePeriodAdderUSec());
        }
        ExprTimePeriodAdder.TimePeriodAdder[] adders = list.toArray(new ExprTimePeriodAdder.TimePeriodAdder[list.size()]);
        this.forge = new ExprTimePeriodForge(this, hasVariables, adders);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        int exprCtr = 0;
        String delimiter = "";
        if (this.hasYear) {
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" years");
            delimiter = " ";
        }
        if (this.hasMonth) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" months");
            delimiter = " ";
        }
        if (this.hasWeek) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" weeks");
            delimiter = " ";
        }
        if (this.hasDay) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" days");
            delimiter = " ";
        }
        if (this.hasHour) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" hours");
            delimiter = " ";
        }
        if (this.hasMinute) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" minutes");
            delimiter = " ";
        }
        if (this.hasSecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" seconds");
            delimiter = " ";
        }
        if (this.hasMillisecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence());
            writer.append(" milliseconds");
            delimiter = " ";
        }
        if (this.hasMicrosecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr].toEPL(writer, this.getPrecedence());
            writer.append(" microseconds");
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprTimePeriodImpl)) {
            return false;
        }
        ExprTimePeriodImpl other = (ExprTimePeriodImpl)node;
        if (this.hasYear != other.hasYear) {
            return false;
        }
        if (this.hasMonth != other.hasMonth) {
            return false;
        }
        if (this.hasWeek != other.hasWeek) {
            return false;
        }
        if (this.hasDay != other.hasDay) {
            return false;
        }
        if (this.hasHour != other.hasHour) {
            return false;
        }
        if (this.hasMinute != other.hasMinute) {
            return false;
        }
        if (this.hasSecond != other.hasSecond) {
            return false;
        }
        if (this.hasMillisecond != other.hasMillisecond) {
            return false;
        }
        return this.hasMicrosecond == other.hasMicrosecond;
    }

    private boolean validate(ExprNode expression) throws ExprValidationException {
        if (expression == null) {
            return false;
        }
        Class returnType = expression.getForge().getEvaluationType();
        if (!JavaClassHelper.isNumeric(returnType)) {
            throw new ExprValidationException("Time period expression requires a numeric parameter type");
        }
        if ((this.hasMonth || this.hasYear) && JavaClassHelper.getBoxedType(returnType) != Integer.class) {
            throw new ExprValidationException("Time period expressions with month or year component require integer values, received a " + returnType.getSimpleName() + " value");
        }
        return expression instanceof ExprVariableNode;
    }
}

